﻿--[[
Name: Babble-Boss-2.2
Revision: $Rev: 46238 $
Author(s): ckknight (ckknight@gmail.com)
Credits: Funkydude
Website: http://ckknight.wowinterface.com/
Documentation: http://wiki.wowace.com/index.php/Babble-Boss-2.2
SVN: http://svn.wowace.com/root/trunk/Babble-2.2/Babble-Boss-2.2
Description: A library to provide localizations for bosses.
Dependencies: AceLibrary, AceLocale-2.2
License: MIT
]]

local MAJOR_VERSION = "Babble-Boss-2.2"
local MINOR_VERSION = tonumber(string.sub("$Revision: 46238 $", 12, -3))

if not AceLibrary then error(MAJOR_VERSION .. " requires AceLibrary") end

if not AceLibrary:HasInstance("AceLocale-2.2") then error(MAJOR_VERSION .. " requires AceLocale-2.2") end

local _, x = AceLibrary("AceLocale-2.2"):GetLibraryVersion()
MINOR_VERSION = MINOR_VERSION * 100000 + x

if not AceLibrary:IsNewVersion(MAJOR_VERSION, MINOR_VERSION) then return end

local BabbleBoss = AceLibrary("AceLocale-2.2"):new(MAJOR_VERSION)

-- uncomment below for debug information
-- BabbleBoss:EnableDebugging()

BabbleBoss:RegisterTranslations("enUS", function() return {
		["Avalanchion"] = true,
		["The Windreaver"] = true,
		["Baron Charr"] = true,
		["Princess Tempestria"] = true,
		["Onyxia"] = true,
		["Azuregos"] = true,
		["Ysondre"] = true,
		["Emeriss"] = true,
		["Taerar"] = true,
		["Lethon"] = true,
		["Ayamiss the Hunter"] = true,
		["Buru the Gorger"] = true,
		["General Rajaxx"] = true,
		["Lieutenant General Andorov"] = true,
		["Moam"] = true,
		["Anubisath Guardian"] = true,
		["Ossirian the Unscarred"] = true,
		["Alzzin the Wildshaper"] = true,
		["Ambassador Flamelash"] = true,
		["Anger'rel"] = true,
		["Archivist Galford"] = true,
		["Bael'Gar"] = true,
		["Balnazzar"] = true,
		["Baroness Anastari"] = true,
		["Baron Rivendare"] = true,
		["Cannon Master Willey"] = true,
		["Captain Kromcrush"] = true,
		["Crystal Fang"] = true,
		["Darkmaster Gandling"] = true,
		["Doctor Theolen Krastinov"] = true,
		["Doom'rel"] = true,
		["Dope'rel"] = true,
		["Emperor Dagran Thaurissan"] = true,
		["Fineous Darkvire"] = true,
		["Gasher"] = true,
		["General Angerforge"] = true,
		["General Drakkisath"] = true,
		["Gloom'rel"] = true,
		["Golem Lord Argelmach"] = true,
		["Goraluk Anvilcrack"] = true,
		["Guard Fengus"] = true,
		["Guard Mol'dar"] = true,
		["Guard Slip'kik"] = true,
		["Gyth"] = true,
		["Halycon"] = true,
		["Hate'rel"] = true,
		["Hearthsinger Forresten"] = true,
		["High Interrogator Gerstahn"] = true,
		["Highlord Omokk"] = true,
		["Hukku"] = true,
		["Hurley Blackbreath"] = true,
		["Hydrospawn"] = true,
		["Illyanna Ravenoak"] = true,
		["Immol'thar"] = true,
		["Instructor Malicia"] = true,
		["Jandice Barov"] = true,
		["King Gordok"] = true,
		["Kirtonos the Herald"] = true,
		["Lady Illucia Barov"] = true,
		["Lethtendris"] = true,
		["Lord Alexei Barov"] = true,
		["Lord Incendius"] = true,
		["Lord Valthalak"] = true,
		["Lorekeeper Polkelt"] = true,
		["Loro"] = true,
		["Magister Kalendris"] = true,
		["Magistrate Barthilas"] = true,
		["Magmus"] = true,
		["Maleki the Pallid"] = true,
		["Marduk Blackpool"] = true,
		["Mijan"] = true,
		["Mother Smolderweb"] = true,
		["Nerub'enkan"] = true,
		["Overlord Wyrmthalak"] = true,
		["Phalanx"] = true,
		["Plugger Spazzring"] = true,
		["Postmaster Malown"] = true,
		["Princess Moira Bronzebeard"] = true,
		["Prince Tortheldrin"] = true,
		["Pusillin"] = true,
		["Pyroguard Emberseer"] = true,
		["Ramstein the Gorger"] = true,
		["Ras Frostwhisper"] = true,
		["Rattlegore"] = true,
		["Warchief Rend Blackhand"] = true,
		["Ribbly Screwspigot"] = true,
		["Seeth'rel"] = true,
		["Shadow Hunter Vosh'gajin"] = true,
		["Solakar Flamewreath"] = true,
		["Stomper Kreeg"] = true,
		["Tendris Warpwood"] = true,
		["The Beast"] = true,
		["The Ravenian"] = true,
		["Timmy the Cruel"] = true,
		["Tsu'zee"] = true,
		["Vectus"] = true,
		["Vile'rel"] = true,
		["War Master Voone"] = true,
		["Zevrim Thornhoof"] = true,
		["Zolo"] = true,
		["Zul'Lor"] = true,

		-- From Mendeleev
		["Cho'Rush the Observer"] = true,
		["Lord Hel'nurath"] = true,
		["Pimgib"] = true,
		["Knot Thimblejack's Cache"] = true,
		["Archmage Arugal"] = true,
		["Arugal's Voidwalker"] = true,
		["Baron Silverlaine"] = true,
		["Commander Springvale"] = true,
		["Deathsworn Captain"] = true,
		["Fenrus the Devourer"] = true,
		["Odo the Blindwatcher"] = true,
		["Razorclaw the Butcher"] = true,
		["Wolf Master Nandos"] = true,
		["Kurinnaxx"] = true,

		-- OUTLANDS
		-- XXX: These are subject to change and may not be correct.
		["Doom Lord Kazzak"] = true,
		["Doomwalker"] = true,

		-- Karazhan
		["Prince Malchezaar"] = true,
		["Attumen the Huntsman"] = true,
		["Midnight"] = true,
		["Hyakiss the Lurker"] = true,
		["Rokad the Ravager"] = true,
		["Shadikith the Glider"] = true,
		["Moroes"] = true,
		["Maiden of Virtue"] = true,
		["Dorothee"] = true,
		["Tito"] = true,
		["Tinhead"] = true,
		["Strawman"] = true,
		["Roar"] = true,
		["The Crone"] = true,
		["Romulo"] = true,
		["Julianne"] = true,
		["Romulo & Julianne"] = true,
		["The Big Bad Wolf"] = true,
		["Grandmother"] = true,
		["The Curator"] = true,
		["Shade of Aran"] = true,
		["Terestian Illhoof"] = true,
		["Kil'rek"] = true,
		["Netherspite"] = true,
		["Nightbane"] = true,
		["Restless Skeleton"] = true,
		["King Llane Piece"] = true,
		["Warchief Blackhand Piece"] = true,
		["Arcane Watchman"] = true,
		["Chess Event"] = true,
		-- Caverns of Time
		--   Durnholde Keep
		["Lieutenant Drake"] = true,
		["Captain Skarloc"] = true,
		["Epoch Hunter"] = true,
		--   The Black Morass
		["Medivh"] = true,
		["Chrono Lord Deja"] = true,
		["Temporus"] = true,
		["Aeonus"] = true,
		--   Battle of Mount Hyjal (subject to change)
		["Rage Winterchill"] = true,
		["Anetheron"] = true,
		["Kaz'rogal"] = true,
		["Azgalor"] = true,
		["Archimonde"] = true,
		-- Magtheridon's Lair
		["Magtheridon"] = true,
		["Hellfire Channeler"] = true,
		-- The Underbog
		["Hungarfen"] = true,
		["Ghaz'an"] = true,
		["Overseer Tidewrath"] = true,
		["Claw"] = true,
		["Swamplord Musel'ek"] = true,
		["The Black Stalker"] = true,
		-- The Steamvault
		["Hydromancer Thespia"] = true,
		["Mekgineer Steamrigger"] = true,
		["Warlord Kalithresh"] = true,
		-- Mana Tombs
		["Pandemonius"] = true,
		["Tavarok"] = true,
		["Nexus-Prince Shaffar"] = true,
		-- Auchenai Crypts
		["Shirrak the Dead Watcher"] = true,
		["Exarch Maladaar"] = true,
		-- Sethekk Halls
		["Talon King Ikiss"] = true,
		["Darkweaver Syth"] = true,
		-- The Mechanar
		["Gatewatcher Gyro-Kill"] = true,
		["Nethermancer Sepethrea"] = true,
		["Gatewatcher Iron-Hand"] = true,
		["Mechano-Lord Capacitus"] = true,
		["Pathaleon the Calculator"] = true,
		-- The Botanica
		["Commander Sarannis"] = true,
		["High Botanist Freywinn"] = true,
		["Thorngrin the Tender"] = true,
		["Laj"] = true,
		["Warp Splinter"] = true,
		-- The Arcatraz
		["Zereketh the Unbound"] = true,
		["Wrath-Scryer Soccothrates"] = true,
		["Dalliah the Doomsayer"] = true,
		["Harbinger Skyriss"] = true,
		["Warden Mellichar"] = true,
		-- The Eye
		["Kael'thas Sunstrider"] = true,
		["Thaladred the Darkener"] = true,
		["Master Engineer Telonicus"] = true,
		["Grand Astromancer Capernian"] = true,
		["Lord Sanguinar"] = true,
		["Al'ar"] = true,
		["High Astromancer Solarian"] = true,
		["Solarium Agent"] = true,
		["Solarium Priest"] = true,
		["Void Reaver"] = true,
		["Devastation"] = true,
		["Cosmic Infuser"] = true,
		["Infinity Blades"] = true,
		["Staff of Disintegration"] = true,
		["Warp Slicer"] = true,
		["Netherstrand Longbow"] = true,
		["Phaseshift Bulwark"] = true,
		-- Ring of Blood
		["Brokentoe"] = true,
		["Murkblood Twin"] = true,
		["Murkblood Twins"] = true,
		["The Blue Brothers"] = true,
		["Rokdar the Sundered Lord"] = true,
		["Skra'gath"] = true,
		["Warmaul Champion"] = true,
		["Mogor"] = true,

--[[    New Format Separator    ]]

--Ahn'Qiraj
		["Anubisath Defender"] = true,
		["Battleguard Sartura"] = true,
		["C'Thun"] = true,
		["Emperor Vek'lor"] = true,
		["Emperor Vek'nilash"] = true,
		["Eye of C'Thun"] = true,
		["Fankriss the Unyielding"] = true,
		["Lord Kri"] = true,
		["Ouro"] = true,
		["Princess Huhuran"] = true,
		["Princess Yauj"] = true,
		["The Bug Family"] = true,
		["The Prophet Skeram"] = true,
		["The Twin Emperors"] = true,
		["Vem"] = true,
		["Viscidus"] = true,

--Black Temple (subject to change)
		["Illidan Stormrage"] = true,
		["Mother Shahraz"] = true,
		["The Illidari Council"] = true,
		["Lady Malande"] = true,
		["High Warlord Naj'entus"] = true,
		["Teron Gorefiend"] = true,
		["Gathios the Shatterer"] = true,
		["Veras Darkshadow"] = true,
		["Gurtogg Bloodboil"] = true,
		["High Nethermancer Zerevor"] = true,
		["Essence of Desire"] = true,
		["Essence of Suffering"] = true,
		["Essence of Anger"] = true,
		["Reliquary of Souls"] = true,
		["Supremus"] = true,
		["Shade of Akama"] = true,

--Blackfathom Deeps
		["Aku'mai"] = true,
		["Baron Aquanis"] = true,
		["Gelihast"] = true,
		["Ghamoo-ra"] = true,
		["Lady Sarevess"] = true,
		["Twilight Lord Kelris"] = true,
		["Old Serra'kis"] = true,

--Blackrock Depths
		["Anub'shiah"] = true,
		["Gorosh the Dervish"] = true,
		["Grizzle"] = true,
		["Hedrum the Creeper"] = true,
		["High Priestess of Thaurissan"] = true,
		["Houndmaster Grebmar"] = true,
		["Lord Roccor"] = true,
		["Ok'thor the Breaker"] = true,
		["Panzor the Invincible"] = true,
		["The Seven Dwarves"] = true,
		["Verek"] = true,
		["Warder Stilgiss"] = true,

--Blackwing Lair
		["Broodlord Lashlayer"] = true,
		["Chromaggus"] = true,
		["Ebonroc"] = true,
		["Firemaw"] = true,
		["Flamegor"] = true,
		["Grethok the Controller"] = true,
		["Lord Victor Nefarius"] = true,
		["Nefarian"] = true,
		["Razorgore the Untamed"] = true,
		["Vaelastrasz the Corrupt"] = true,

--Gnomeregan
		["Crowd Pummeler 9-60"] = true,
		["Dark Iron Ambassador"] = true,
		["Electrocutioner 6000"] = true,
		["Grubbis"] = true,
		["Mekgineer Thermaplugg"] = true,
		["Techbot"] = true,
		["Viscous Fallout"] = true,

--Gruul's Lair
		["Gruul the Dragonkiller"] = true,
		["High King Maulgar"] = true,
		["Kiggler the Crazed"] = true,
		["Blindeye the Seer"] = true,
		["Olm the Summoner"] = true,
		["Krosh Firehand"] = true,

--Hellfire Ramparts
		["Nazan"] = true,
		["Omor the Unscarred"] = true,
		["Vazruden"] = true,
		["Vazruden the Herald"] = true,
		["Watchkeeper Gargolmar"] = true,

--Maraudon
		["Celebras the Cursed"] = true,
		["Gelk"] = true,
		["Kolk"] = true,
		["Landslide"] = true,
		["Lord Vyletongue"] = true,
		["Magra"] = true,
		["Maraudos"] = true,
		["Meshlok the Harvester"] = true,
		["Noxxion"] = true,
		["Princess Theradras"] = true,
		["Razorlash"] = true,
		["Rotgrip"] = true,
		["Tinkerer Gizlock"] = true,
		["Veng"] = true,

--Molten Core
		["Baron Geddon"] = true,
		["Garr"] = true,
		["Gehennas"] = true,
		["Golemagg the Incinerator"] = true,
		["Lucifron"] = true,
		["Magmadar"] = true,
		["Majordomo Executus"] = true,
		["Ragnaros"] = true,
		["Shazzrah"] = true,
		["Sulfuron Harbinger"] = true,

--Naxxramas
		["Anub'Rekhan"] = true,
		["Deathknight Understudy"] = true,
		["Feugen"] = true,
		["Gluth"] = true,
		["Gothik the Harvester"] = true,
		["Grand Widow Faerlina"] = true,
		["Grobbulus"] = true,
		["Heigan the Unclean"] = true,
		["Highlord Mograine"] = true,
		["Instructor Razuvious"] = true,
		["Kel'Thuzad"] = true,
		["Lady Blaumeux"] = true,
		["Loatheb"] = true,
		["Maexxna"] = true,
		["Noth the Plaguebringer"] = true,
		["Patchwerk"] = true,
		["Sapphiron"] = true,
		["Sir Zeliek"] = true,
		["Stalagg"] = true,
		["Thaddius"] = true,
		["Thane Korth'azz"] = true,
		["The Four Horsemen"] = true,

--Ragefire Chasm
		["Bazzalan"] = true,
		["Jergosh the Invoker"] = true,
		["Maur Grimtotem"] = true,
		["Taragaman the Hungerer"] = true,

--Razorfen Downs
		["Amnennar the Coldbringer"] = true,
		["Glutton"] = true,
		["Mordresh Fire Eye"] = true,
		["Plaguemaw the Rotting"] = true,
		["Ragglesnout"] = true,
		["Tuten'kash"] = true,

--Razorfen Kraul
		["Agathelos the Raging"] = true,
		["Blind Hunter"] = true,
		["Charlga Razorflank"] = true,
		["Death Speaker Jargba"] = true,
		["Earthcaller Halmgar"] = true,
		["Overlord Ramtusk"] = true,

--Scarlet Monastery
		["Arcanist Doan"] = true,
		["Azshir the Sleepless"] = true,
		["Bloodmage Thalnos"] = true,
		["Fallen Champion"] = true,
		["Herod"] = true,
		["High Inquisitor Fairbanks"] = true,
		["High Inquisitor Whitemane"] = true,
		["Houndmaster Loksey"] = true,
		["Interrogator Vishas"] = true,
		["Ironspine"] = true,
		["Scarlet Commander Mograine"] = true,

--Serpentshrine Cavern
		["Hydross the Unstable"] = true,
		["Tainted Spawn of Hydross"] = true,
		["Pure Spawn of Hydross"] = true,
		["Fathom-Lord Karathress"] = true,
		["Morogrim Tidewalker"] = true,
		["Tidewalker Lurker"] = true,
		["Leotheras the Blind"] = true,
		["Shadow of Leotheras"] = true,
		["Lady Vashj"] = true,
		["Coilfang Elite"] = true,
		["Coilfang Strider"] = true,
		["The Lurker Below"] = true,

--Shadow Labyrinth
		["Ambassador Hellmaw"] = true,
		["Blackheart the Inciter"] = true,
		["Grandmaster Vorpil"] = true,
		["Murmur"] = true,

--The Blood Furnace
		["Broggok"] = true,
		["Keli'dan the Breaker"] = true,
		["The Maker"] = true,

--The Deadmines
		["Brainwashed Noble"] = true,
		["Captain Greenskin"] = true,
		["Cookie"] = true,
		["Edwin VanCleef"] = true,
		["Gilnid"] = true,
		["Marisa du'Paige"] = true,
		["Miner Johnson"] = true,
		["Mr. Smite"] = true,
		["Rhahk'Zor"] = true,
		["Sneed"] = true,
		["Sneed's Shredder"] = true,

--The Shattered Halls
		["Grand Warlock Nethekurse"] = true,
		["Warbringer O'mrogg"] = true,
		["Warchief Kargath Bladefist"] = true,
		["Blood Guard Porung"] = true,

--The Slave Pens
		["Mennu the Betrayer"] = true,
		["Quagmirran"] = true,
		["Rokmar the Crackler"] = true,

--The Stockade
		["Bazil Thredd"] = true,
		["Bruegal Ironknuckle"] = true,
		["Dextren Ward"] = true,
		["Hamhock"] = true,
		["Kam Deepfury"] = true,
		["Targorr the Dread"] = true,

--The Temple of Atal'Hakkar
		["Atal'alarion"] = true,
		["Avatar of Hakkar"] = true,
		["Dreamscythe"] = true,
		["Hazzas"] = true,
		["Jammal'an the Prophet"] = true,
		["Morphaz"] = true,
		["Ogom the Wretched"] = true,
		["Shade of Eranikus"] = true,
		["Weaver"] = true,

--Uldaman
		["Ancient Stone Keeper"] = true,
		["Archaedas"] = true,
		["Baelog"] = true,
		["Digmaster Shovelphlange"] = true,
		["Galgann Firehammer"] = true,
		["Grimlok"] = true,
		["Ironaya"] = true,
		["Obsidian Sentinel"] = true,
		["Revelosh"] = true,

--Wailing Caverns
		["Boahn"] = true,
		["Deviate Faerie Dragon"] = true,
		["Kresh"] = true,
		["Lady Anacondra"] = true,
		["Lord Cobrahn"] = true,
		["Lord Pythas"] = true,
		["Lord Serpentis"] = true,
		["Mad Magglish"] = true,
		["Mutanus the Devourer"] = true,
		["Skum"] = true,
		["Trigore the Lasher"] = true,
		["Verdan the Everliving"] = true,

--World Bosses
		["Baron Kazum"] = true,
		["High Marshal Whirlaxis"] = true,
		["Lord Skwol"] = true,

--Zul'Aman
		["Warlord Jin'Zakk"] = true,

--Zul'Farrak
		["Antu'sul"] = true,
		["Chief Ukorz Sandscalp"] = true,
		["Gahz'rilla"] = true,
		["Hydromancer Velratha"] = true,
		["Nekrum Gutchewer"] = true,
		["Ruuzlu"] = true,
		["Sandfury Executioner"] = true,
		["Sergeant Bly"] = true,
		["Theka the Martyr"] = true,
		["Witch Doctor Zum'rah"] = true,
		["Zerillis"] = true,
		["Zul'Farrak Dead Hero"] = true,

--Zul'Gurub
		["Bloodlord Mandokir"] = true,
		["Gahz'ranka"] = true,
		["Gri'lek"] = true,
		["Hakkar"] = true,
		["Hazza'rah"] = true,
		["High Priestess Arlokk"] = true,
		["High Priestess Jeklik"] = true,
		["High Priestess Mar'li"] = true,
		["High Priest Thekal"] = true,
		["High Priest Venoxis"] = true,
		["Jin'do the Hexxer"] = true,
		["Renataki"] = true,
		["Wushoolay"] = true,
} end)

BabbleBoss:RegisterTranslations("deDE", function() return {
		["Avalanchion"] = "Avalanchion",
		["The Windreaver"] = "Der Windh\195\164scher",
		["Baron Charr"] = "Baron Glutarr",
		["Princess Tempestria"] = "Prinzessin Tempestria",
		["Onyxia"] = "Onyxia",
		["Azuregos"] = "Azuregos",
		["Emeriss"] = "Smariss",
		["Taerar"] = "Taerar",
		["Lethon"] = "Lethon",
		["Ysondre"] = "Ysondre",
		["Ayamiss the Hunter"] = "Ayamiss der J\195\164ger",
		["Buru the Gorger"] = "Buru der Verschlinger",
		["General Rajaxx"] = "General Rajaxx",
		["Lieutenant General Andorov"] = "Generallieutenant Andorov",
		["Moam"] = "Moam",
		["Anubisath Guardian"] = "Besch\195\188tzer des Anubisath",
		["Ossirian the Unscarred"] = "Ossirian der Narbenlose",
		["Alzzin the Wildshaper"] = "Alzzin der Wildformer",
		["Ambassador Flamelash"] = "Botschafter Flammenschlag",
		["Anger'rel"] = "Anger'rel",
		["Archivist Galford"] = "Archivar Galford",
		["Bael'Gar"] = "Bael'Gar",
		["Balnazzar"] = "Balnazzar",
		["Baroness Anastari"] = "Baroness Anastari",
		["Baron Rivendare"] = "Baron Totenschwur",
		["Captain Kromcrush"] = "Hauptmann Krombruch",
		["Crystal Fang"] = "Kristallfangzahn",
		["Darkmaster Gandling"] = "Dunkelmeister Gandling",
		["Doctor Theolen Krastinov"] = "Doktor Theolen Krastinov",
		["Doom'rel"] = "Un'rel",
		["Dope'rel"] = "Trott'rel",
		["Fineous Darkvire"] = "Fineous Dunkelader",
		["Gasher"] = "Schlitzer",
		["General Angerforge"] = "General Zornesschmied",
		["General Drakkisath"] = "General Drakkisath",
		["Gloom'rel"] = "Dunk'rel",
		["Golem Lord Argelmach"] = "Golemlord Argelmach",
		["Goraluk Anvilcrack"] = "Goraluk Hammerbruch",
		["Gyth"] = "Gyth",
		["Halycon"] = "Halycon",
		["Hate'rel"] = "Hass'rel",
		["Hearthsinger Forresten"] = "Herdsinger Forresten",
		["Highlord Omokk"] = "Hochlord Omokk",
		["Hukku"] = "Hukku",
		["Hurley Blackbreath"] = "Hurley Pestatem",
		["Hydrospawn"] = "Hydrobrut",
		["Illyanna Ravenoak"] = "Illyanna Rabeneiche",
		["Immol'thar"] = "Immol'thar",
		["Instructor Malicia"] = "Instrukteurin Malicia",
		["Jandice Barov"] = "Jandice Barov",
		["Kirtonos the Herald"] = "Kirtonos der Herold",
		["Lady Illucia Barov"] = "Lady Illucia Barov",
		["Lethtendris"] = "Lethtendris",
		["Lorekeeper Polkelt"] = "H\195\188ter des Wissens Polkelt",
		["Loro"] = "Loro",
		["Magister Kalendris"] = "Magister Kalendris",
		["Magistrate Barthilas"] = "Magistrat Barthilas",
		["Magmus"] = "Magmus",
		["Maleki the Pallid"] = "Maleki der Leichenblasse",
		["Marduk Blackpool"] = "Marduk Blackpool",
		["Mijan"] = "Mijan",
		["Mother Smolderweb"] = "Mutter Glimmernetz",
		["Nerub'enkan"] = "Nerub'enkan",
		["Overlord Wyrmthalak"] = "Oberanf\195\188hrer Wyrmthalak",
		["Phalanx"] = "Phalanx",
		["Plugger Spazzring"] = "St\195\182psel Zapfring",
		["Postmaster Malown"] = "Postmeister Malown",
		["Princess Moira Bronzebeard"] = "Prinzessin Moira Bronzebeard",
		["Prince Tortheldrin"] = "Prinz Tortheldrin",
		["Pusillin"] = "Pusillin",
		["Pyroguard Emberseer"] = "Feuerwache Glutseher",
		["Ramstein the Gorger"] = "Ramstein der Verschlinger",
		["Rattlegore"] = "Blutrippe",
		["Ribbly Screwspigot"] = "Ribbly Schraubstutz",
		["Seeth'rel"] = "Wut'rel",
		["Solakar Flamewreath"] = "Solakar Feuerkrone",
		["Stomper Kreeg"] = "Stampfer Kreeg",
		["Tendris Warpwood"] = "Tendris Wucherborke",
		["Timmy the Cruel"] = "Timmy der Grausame",
		["Tsu'zee"] = "Tsu'zee",
		["Vectus"] = "Vectus",
		["Vile'rel"] = "B\195\182s'rel",
		["Zevrim Thornhoof"] = "Zevrim Dornhuf",
		["Zolo"] = "Zolo",
		["Zul'Lor"] = "Zul'Lor",
		["Cannon Master Willey"] = "Kanonenmeister Willey",
		["Emperor Dagran Thaurissan"] = "Imperator Dagran Thaurissan",
		["Guard Fengus"] = "Wache Fengus",
		["Guard Mol'dar"] = "Wache Mol'dar",
		["Guard Slip'kik"] = "Wache Slip'kik",
		["High Interrogator Gerstahn"] = "Verh\195\182rmeisterin Gerstahn",
		["King Gordok"] = "K\195\182nig Gordok",
		["Lord Alexei Barov"] = "Lord Alexei Barov",
		["Lord Incendius"] = "Lord Incendius",
		["Lord Valthalak"] = "Lord Valthalak",
		["Ras Frostwhisper"] = "Ras Frostraunen",
		["Warchief Rend Blackhand"] = "Kriegsh\195\164uptling Rend Schwarzfaust",
		["Shadow Hunter Vosh'gajin"] = "Schattenj\195\164gerin Vosh'gajin",
		["The Beast"] = "Die Bestie",
		["The Ravenian"] = "Der Ravenier",
		["War Master Voone"] = "Kriegsmeister Voone",

		-- From Mendeleev
		["Cho'Rush the Observer"] = "Cho'Rush der Beobachter",
		["Lord Hel'nurath"] = "Lord Hel'nurath",
		["Pimgib"] = "Pimgib",
		["Knot Thimblejack's Cache"] = "Knot Thimblejacks Truhe",
		["Archmage Arugal"] = "Erzmagier Arugal",
		["Arugal's Voidwalker"] = "Arugals Leerwandler",
		["Baron Silverlaine"] = "Baron Silberlein",
		["Commander Springvale"] = "Kommandant Springvale",
		["Deathsworn Captain"] = "Todesh\195\182riger Captain",
		["Fenrus the Devourer"] = "Fenrus der Verschlinger",
		["Odo the Blindwatcher"] = "Odo der Blindseher",
		["Razorclaw the Butcher"] = "Klingenklaue der Metzger",
		["Wolf Master Nandos"] = "Wolfmeister Nados",
		["Kurinnaxx"] = "Kurinnaxx",

		-- OUTLANDS
		-- XXX: These are subject to change and may not be correct.
		["Doom Lord Kazzak"] = "Verdammnislord Kazzak",
		["Doomwalker"] = "Verdammniswandler",

		-- Karazhan
		["Prince Malchezaar"] = "Prinz Malchezaar",
		["Attumen the Huntsman"] = "Attumen der J\195\164ger",
		["Midnight"] = "Mittnacht",
		["Hyakiss the Lurker"] = "Hyakiss der Lauerer",
		["Rokad the Ravager"] = "Rokad der Verheerer",
		["Shadikith the Glider"] = "Shadikith der Segler",
		["Moroes"] = "Moroes",
		["Maiden of Virtue"] = "Tugendhafte Maid",
		["Dorothee"] = "Dorothee",
		["Tito"] = "Tito",
		["Tinhead"] = "Blechkopf",
		["Strawman"] = "Strohmann",
		["Roar"] = "Br\195\188ller",
		["The Crone"] = "Die b\195\182se Hexe",
		["Romulo"] = "Romulo",
		["Julianne"] = "Julianne",
		["Romulo & Julianne"] = "Romulo & Julianne",
		["The Big Bad Wolf"] = "Der gro\195\159e b\195\182se Wolf",
		["Grandmother"] = "Gro\195\159mutter",
		["The Curator"] = "Der Kurator",
		["Shade of Aran"] = "Arans Schemen",
		["Terestian Illhoof"] = "Terestian Siechhuf",
		["Kil'rek"] = "Kil'rek",
		["Netherspite"] = "Nethergroll",
		["Nightbane"] = "Schrecken der Nacht",
		["Restless Skeleton"] = "Ruheloses Skelett",
		["Chess Event"] = "Chess Event",
		["King Llane Piece"] = "K\195\182nig Llane",
		["Warchief Blackhand Piece"] = "Kriegsh\195\164uptling Schwarzfaust",
		-- Caverns of Time
		--   Durnholde Keep
		["Lieutenant Drake"] = "Leutnant Drach",
		["Captain Skarloc"] = "Kapit\195\164n Skarloc",
		["Epoch Hunter"] = "Epochenj\195\164ger",
		--   The Black Morass
		["Medivh"] = "Medivh",
		["Chrono Lord Deja"] = "Chronolord Deja",
		["Temporus"] = "Temporus",
		["Aeonus"] = "Aeonus",
    --   Battle of Mount Hyjal (subject to change)
		["Rage Winterchill"] = "Furor Winterfrost",
		["Anetheron"] = "Anetheron",
		["Kaz'rogal"] = "Kaz'rogal",
		["Azgalor"] = "Azgalor",
		["Archimonde"] = "Archimonde",
		-- Magtheridon's Lair
		["Magtheridon"] = "Magtheridon",
		["Hellfire Channeler"] = "Kanalisierer des H\195\182llenfeuers",
		-- The Underbog
		["Hungarfen"] = "Hungarfenn",
		["Ghaz'an"] = "Ghaz'an",
		["Overseer Tidewrath"] = "Overseer Tidewrath",
		["Claw"] = "Klaue",
		["Swamplord Musel'ek"] = "Sumpff\195\188rst Musel'ek",
		["The Black Stalker"] = "Die Schattenmutter",
		-- The Steamvault
		["Hydromancer Thespia"] = "Wasserbeschw\195\182rerin Thespia",
		["Mekgineer Steamrigger"] = "Robogenieur Dampfhammer",
		["Warlord Kalithresh"] = "Kriegsherr Kalithresh",
		-- Mana Tombs
		["Pandemonius"] = "Pandemonius",
		["Tavarok"] = "Tavarok",
		["Nexus-Prince Shaffar"] = "Nexusprinz Shaffar",
		-- Auchenai Crypts
		["Shirrak the Dead Watcher"] = "Shirrak der Totenw\195\164chter",
		["Exarch Maladaar"] = "Exarch Maladaar",
		-- Sethekk Halls
		["Talon King Ikiss"] = "Klauenk\195\182nig Ikiss",
		["Darkweaver Syth"] = "Dunkelwirker Syth",
		-- The Mechanar
		["Gatewatcher Gyro-Kill"] = "Torw\195\164chter Gyrotot",
		["Nethermancer Sepethrea"] = "Nethermant Sepethrea",
		["Gatewatcher Iron-Hand"] = "Torw\195\164chter Eisenhand",
		["Mechano-Lord Capacitus"] = "Mechanolord Kapazitus",
		["Pathaleon the Calculator"] = "Pathaleon der Kalkulator",
		-- The Botanica
		["Commander Sarannis"] = "Kommandant Sarannis",
		["High Botanist Freywinn"] = "Hochbotaniker Freywinn",
		["Thorngrin the Tender"] = "Dorngrin der H\195\188ter",
		["Laj"] = "Laj",
		["Warp Splinter"] = "Warpzweig",
		-- The Arcatraz
		["Zereketh the Unbound"] = "Zereketh der Unabh\195\164ngige",
		["Wrath-Scryer Soccothrates"] = "Zornseher Soccothrates",
		["Dalliah the Doomsayer"] = "Dalliah die Verdammnisverk\195\188nderin",
		["Harbinger Skyriss"] = "Herold Horizontiss",
		["Warden Mellichar"] = "Aufseher Mellichar",
		-- The Eye
		["Kael'thas Sunstrider"] = "Kael'thas Sonnenwanderer",
		["Thaladred the Darkener"] = "Thaladred der Verfinsterer",
		["Master Engineer Telonicus"] = "Meisteringenieur Telonicus",
		["Grand Astromancer Capernian"] = "Gro\195\159astronom Capernian",
		["Lord Sanguinar"] = "F\195\188rst Blutdurst",
		["Al'ar"] = "Al'ar",
		["High Astromancer Solarian"] = "Hochastronom Solarian",
		["Solarium Agent"] = "Solarian Agent",
		["Solarium Priest"] = "Solarian Priester",
		["Void Reaver"] = "Leerh\195\164scher",
		["Devastation"] = "Verw\195\188stung",
		["Cosmic Infuser"] = "Kosmische Macht",
		["Infinity Blades"] = "Klinge der Unendlichkeit",
		["Staff of Disintegration"] = "Stab der Aufl\195\182sung",
		["Warp Slicer"] = "Warpschnitter",
		["Netherstrand Longbow"] = "Netherbespannter Langbogen",
		["Phaseshift Bulwark"] = "Phasenverschobenes Bollwerk",
		-- Ring of Blood
		["Brokentoe"] = "Schmetterzehe",
		["Murkblood Twin"] = "Zwilling der Finsterblut",
		["Murkblood Twins"] = "Zwillinge der Finsterblut",
		["The Blue Brothers"] = "Die Blaum\195\164nner",
		["Rokdar the Sundered Lord"] = "Rokdar der Zerkl\195\188ftete",
		["Skra'gath"] = "Skra'gath",
		["Warmaul Champion"] = "Champion der Totschl\195\164ger",
		["Mogor"] = "Mogor",

--[[    New Format Separator    ]]

--Ahn'Qiraj
		["Anubisath Defender"] = "Verteidiger des Anubisath",
		["Battleguard Sartura"] = "Schlachtwache Sartura",
		["C'Thun"] = "C'Thun",
		["Emperor Vek'lor"] = "Imperator Vek'lor",
		["Emperor Vek'nilash"] = "Imperator Vek'nilash",
		["Eye of C'Thun"] = "Auge von C'Thun",
		["Fankriss the Unyielding"] = "Fankriss der Unnachgiebige",
		["Lord Kri"] = "Lord Kri",
		["Ouro"] = "Ouro",
		["Princess Huhuran"] = "Prinzessin Huhuran",
		["Princess Yauj"] = "Prinzessin Yauj",
		["The Bug Family"] = "Die K\195\164ferfamilie",
		["The Prophet Skeram"] = "Der Prophet Skeram",
		["The Twin Emperors"] = "Die Zwillings-Imperatoren",
		["Vem"] = "Vem",
		["Viscidus"] = "Viscidus",

--Black Temple
		["Illidan Stormrage"] = "Illidan Sturmgrimm",
		["Mother Shahraz"] = "Mutter Shahraz",
		["The Illidari Council"] = "Rat der Illidari",
		["Lady Malande"] = "Lady Malande",
		["High Warlord Naj'entus"] = "Oberster Kriegsf\195\188rst Naj'entus",
		["Teron Gorefiend"] = "Teron Blutschatten",
		["Gathios the Shatterer"] = "Gathios der Zerschmetterer",
		["Veras Darkshadow"] = "Veras Schwarzschatten",
		["Gurtogg Bloodboil"] = "Gurtogg Siedeblut",
		["High Nethermancer Zerevor"] = "Hochnethermant Zerevor",
		["Essence of Desire"] = "Essenz der Begierde",
		["Essence of Suffering"] = "Essenz des Leidens",
		["Essence of Anger"] = "Essenz des Zorns",
		["Reliquary of Souls"] = "Reliquium der Seelen",
		["Supremus"] = "Supremus",
		["Shade of Akama"] = "Akamas Schemen",

--Blackfathom Deeps
		["Aku'mai"] = "Aku'mai",
		["Baron Aquanis"] = "Baron Aquanis",
		["Gelihast"] = "Gelihast",
		["Ghamoo-ra"] = "Ghamoo-ra",
		["Lady Sarevess"] = "Lady Sarevess",
		["Twilight Lord Kelris"] = "Lord des Schattenhammers Kelris",
		["Old Serra'kis"] = "Old Serra'kis",

--Blackrock Depths
		["Anub'shiah"] = "Anub'shiah",
		["Gorosh the Dervish"] = "Gorosh der Derwisch",
		["Grizzle"] = "Grizzle",
		["Hedrum the Creeper"] = "Hedrum der Krabbler",
		["High Priestess of Thaurissan"] = "	Hohepriesterin von Thaurissan",
		["Houndmaster Grebmar"] = "Hundemeister Grebmar",
		["Lord Roccor"] = "Lord Roccor",
		["Ok'thor the Breaker"] = "Ok'thor der Zerst\195\182rer",
		["Panzor the Invincible"] = "Panzor der Unbesiegbare",
		["The Seven Dwarves"] = "Die Sieben Zwerge",
		["Verek"] = "Verek",
		["Warder Stilgiss"] = "	W\195\164rter Stilgiss",

--Blackwing Lair
		["Broodlord Lashlayer"] = "Brutw\195\164chter Dreschbringer",
		["Chromaggus"] = "Chromaggus",
		["Ebonroc"] = "Schattenschwinge",
		["Firemaw"] = "Feuerschwinge",
		["Flamegor"] = "Flammenmaul",
		["Grethok the Controller"] = "Grethok der Aufseher",
		["Lord Victor Nefarius"] = "Lord Victor Nefarius",
		["Nefarian"] = "Nefarian",
		["Razorgore the Untamed"] = "Razorgore der Ungez\195\164hmte",
		["Vaelastrasz the Corrupt"] = "Vaelastrasz der Verdorbene",

--Gnomeregan
		["Crowd Pummeler 9-60"] = "Meuteverpr\195\188gler 9-60",
		["Dark Iron Ambassador"] = "Botschafter der Dunkeleisenzwerge",
		["Electrocutioner 6000"] = "Elektrokutor 6000",
		["Grubbis"] = "Grubbis",
		["Mekgineer Thermaplugg"] = "Robogenieur Thermadraht",
		["Techbot"] = "Techbot",
		["Viscous Fallout"] = "Verflüssigte Ablagerung",

--Gruul's Lair
		["Gruul the Dragonkiller"] = "Gruul der Drachenschl\195\164chter",
		["High King Maulgar"] = "Hochk\195\182nig Maulgar",
		["Kiggler the Crazed"] = "Kiggler the Crazed",
		["Blindeye the Seer"] = "Blindauge der Seher",
		["Olm the Summoner"] = "Olm der Beschwörer",
		["Krosh Firehand"] = "Krosh Feuerhand",

--Hellfire Ramparts
		["Nazan"] ="Nazan",
		["Omor the Unscarred"] = "Omor der Narbenlose",
		["Vazruden"] = "Vazruden",
		["Vazruden the Herald"] = "Vazruden der Herold",
		["Watchkeeper Gargolmar"] = "Wachhabender Gargolmar",

--Maraudon
		["Celebras the Cursed"] = "Celebras der Verfluchte",
		["Gelk"] = "Gelk",
		["Kolk"] = "Kolk",
		["Landslide"] = "Erdrutsch",
		["Lord Vyletongue"] = "Lord Schlangenzunge",
		["Magra"] = "Magra",
		["Maraudos"] = "Maraudos",
		["Meshlok the Harvester"] = "Meshlok der Ernter",
		["Noxxion"] = "Noxxion",
		["Princess Theradras"] = "Prinzessin Theradras",
		["Razorlash"] = "Schlingwurzler",
		["Rotgrip"] = "Faulschnapper",
		["Tinkerer Gizlock"] = "T\195\188ftler Gizlock",
		["Veng"] = "Veng",

--Molten Core
		["Baron Geddon"] = "Baron Geddon",
		["Garr"] = "Garr",
		["Gehennas"] = "Gehennas",
		["Golemagg the Incinerator"] = "Golemagg der Verbrenner",
		["Lucifron"] = "Lucifron",
		["Magmadar"] = "Magmadar",
		["Majordomo Executus"] = "Majordomus Exekutus",
		["Ragnaros"] = "Ragnaros",
		["Shazzrah"] = "Shazzrah",
		["Sulfuron Harbinger"] = "Sulfuronherold",

--Naxxramas
		["Anub'Rekhan"] = "Anub'Rekhan",
		["Deathknight Understudy"] = "Reservist der Todesritter",
		["Feugen"] = "Feugen",
		["Gluth"] = "Gluth",
		["Gothik the Harvester"] = "Gothik der Seelenj\195\164ger",
		["Grand Widow Faerlina"] = "Gro\195\159witwe Faerlina",
		["Grobbulus"] = "Grobbulus",
		["Heigan the Unclean"] = "Heigan der Unreine",
		["Highlord Mograine"] = "Hochlord Mograine",
		["Instructor Razuvious"] = "Instrukteur Razuvious",
		["Kel'Thuzad"] = "Kel'Thuzad",
		["Lady Blaumeux"] = "Lady Blaumeux",
		["Loatheb"] = "Loatheb",
		["Maexxna"] = "Maexxna",
		["Noth the Plaguebringer"] = "Noth der Seuchenf\195\188rst",
		["Patchwerk"] = "Flickwerk",
		["Sapphiron"] = "Saphiron",
		["Sir Zeliek"] = "Sire Zeliek",
		["Stalagg"] = "Stalagg",
		["Thaddius"] = "Thaddius",
		["Thane Korth'azz"] = "Thane Korth'azz",
		["The Four Horsemen"]= "Die Vier Reiter",

--Ragefire Chasm
		["Bazzalan"] = "Bazzalan",
		["Jergosh the Invoker"] = "Jergosh der Herbeirufer",
		["Maur Grimtotem"] = "Maur Grimmtotem",
		["Taragaman the Hungerer"] = "Taragaman der Hungerleider",

--Razorfen Downs
		["Amnennar the Coldbringer"] = "Amnennar der K\195\164ltebringer",
		["Glutton"] = "Nimmersatt",
		["Mordresh Fire Eye"] = "Mordresh Feuerauge",
		["Plaguemaw the Rotting"] = "Seuchenschlund der Faulende",
		["Ragglesnout"] = "Struppm\195\164hne",
		["Tuten'kash"] = "Tuten'kash",

--Razorfen Kraul
		["Agathelos the Raging"] = "Agathelos der Tobende",
		["Blind Hunter"] = "Blinder J\195\164ger",
		["Charlga Razorflank"] = "Charlga Klingenflanke",
		["Death Speaker Jargba"] = "Todessprecher Jargba",
		["Earthcaller Halmgar"] = "Erdenrufer Halmgar",
		["Overlord Ramtusk"] = "Oberanführer Rammhauer",

--Scarlet Monastery
		["Arcanist Doan"] = "Arkanist Doan",
		["Azshir the Sleepless"] = "Azshir der Schlaflose",
		["Bloodmage Thalnos"] = "Blutmagier Thalnos",
		["Fallen Champion"] = "Gest\195\188rzter Held",
		["Herod"] = "Herod",
		["High Inquisitor Fairbanks"] = "Hochinquisitor Fairbanks",
		["High Inquisitor Whitemane"] = "Hochinquisitor Wei\195\159str\195\164hne",
		["Houndmaster Loksey"] = "Hundemeister Loksey",
		["Interrogator Vishas"] = "Befrager Vishas",
		["Ironspine"] = "Eisenr\195\188cken",
		["Scarlet Commander Mograine"] = "Scharlachroter Kommandant Mograine",

--Serpentshrine Cavern
		["Hydross the Unstable"] = "Hydross der Unstete",
		["Tainted Spawn of Hydross"] = "Besudelter Nachkomme Hydross'",
		["Pure Spawn of Hydross"] = "Gereinigter Nachkomme Hydross'",
		["Fathom-Lord Karathress"] = "Tiefenlord Karathress",
		["Morogrim Tidewalker"] = "Morogrim Gezeitenwandler",
		["Tidewalker Lurker"] = "Lauerer der Gezeitenwandler",
		["Leotheras the Blind"] = "Leotheras der Blinde",
		["Shadow of Leotheras"] = "Schatten von Leotheras",
		["Lady Vashj"] = "Lady Vashj",
		["Coilfang Elite"] = "Elitesoldat des Echsenkessels",
		["Coilfang Strider"] = "Schreiter des Echsenkessels",
		["The Lurker Below"] = "Das Grauen aus der Tiefe",

--Shadow Labyrinth
		["Ambassador Hellmaw"] = "Botschafter H\195\182llenschlund",
		["Blackheart the Inciter"] = "Schwarzherz der Hetzer",
		["Grandmaster Vorpil"] = "Gro\195\159meister Vorpil",
		["Murmur"] = "Murmur",

--The Blood Furnace
		["Broggok"] = "Broggok",
		["Keli'dan the Breaker"] = "Keli'dan der Zerst\195\182rer",
		["The Maker"] = "Der Sch\195\182pfer",

--The Deadmines
		["Brainwashed Noble"] = "Manipulierter Adliger",
		["Captain Greenskin"] = "Kapit\195\164n Gr\195\188nhaut",
		["Cookie"] = "Kr\195\188mel",
		["Edwin VanCleef"] = "Edwin van Cleef",
		["Gilnid"] = "Gilnid",
		["Marisa du'Paige"] = "Marisa du'Paige",
		["Miner Johnson"] = "Minenarbeiter Johnson",
		["Mr. Smite"] = "Handlanger Pein",
		["Rhahk'Zor"] = "Rhahk'Zor",
		["Sneed"] = "Sneed",
		["Sneed's Shredder"] = "Sneeds Schredder",

--The Shattered Halls
		["Grand Warlock Nethekurse"] = "Gro\195\159hexenmeister Nethekurse",
		["Warbringer O'mrogg"] = "Kriegshetzer O'mrogg",
		["Warchief Kargath Bladefist"] = "Kriegsh\195\164uptling Kargath Messerfaust",
		["Blood Guard Porung"] = "Blutwache Porung",

--The Slave Pens
		["Mennu the Betrayer"] = "Mennu der Verr\195\164ter",
		["Quagmirran"] = "Quagmirran",
		["Rokmar the Crackler"] = "Rokmar der Zerquetscher",

--The Stockade
		["Bazil Thredd"] = "Bazil Thredd",
		["Bruegal Ironknuckle"] = "Bruegal Eisenfaust",
		["Dextren Ward"] = "Dextren Ward",
		["Hamhock"] = "Hamhock",
		["Kam Deepfury"] = "Kam Tiefenzorn",
		["Targorr the Dread"] = "Targorr der Schreckliche",

--The Temple of Atal'Hakkar
		["Atal'alarion"] = "Atal'alarion",
		["Avatar of Hakkar"] = "Avatar von Hakkar",
		["Dreamscythe"] = "Traumsense",
		["Hazzas"] = "Hazzas",
		["Jammal'an the Prophet"] = "Jammal'an der Prophet",
		["Morphaz"] = "Morphaz",
		["Ogom the Wretched"] = "Ogom der Elende",
		["Shade of Eranikus"] = "Eranikus' Schemen",
		["Weaver"] = "Wirker",

--Uldaman
		["Ancient Stone Keeper"] = "Uralter Steinbewahrer",
		["Archaedas"] = "Archaedas",
		["Baelog"] = "Baelog",
		["Digmaster Shovelphlange"] = "Grubenmeister Schaufelphlansch",
		["Galgann Firehammer"] = "Galgann Feuerhammer",
		["Grimlok"] = "Grimlok",
		["Ironaya"] = "Ironaya",
		["Obsidian Sentinel"] = "Obsidianschildwache",
		["Revelosh"] = "Revelosh",

--Wailing Caverns
		["Boahn"] = "Boahn",
		["Deviate Faerie Dragon"] = "Deviatfeendrache",
		["Kresh"] = "Kresh",
		["Lady Anacondra"] = "Lady Anacondra",
		["Lord Cobrahn"] = "Lord Kobrahn",
		["Lord Pythas"] = "Lord Pythas",
		["Lord Serpentis"] = "Lord Serpentis",
		["Mad Magglish"] = "Zausel der Verr\195\188ckte",
		["Mutanus the Devourer"] = "Mutanus der Verschlinger",
		["Skum"] = "Skum",
		["Trigore the Lasher"] = "Trigore der Peitscher",
		["Verdan the Everliving"] = "Verdan der Ewiglebende",

--World Bosses
		["Baron Kazum"] = "Baron Kazum",
		["High Marshal Whirlaxis"] = "Hochmarschall Whirlaxis",
		["Lord Skwol"] = "Lord Skwol",

--Zul'Aman
		["Warlord Jin'Zakk"] = "Warlord Jin'Zakk",

--Zul'Farrak
		["Antu'sul"] = "Antu'sul",
		["Chief Ukorz Sandscalp"] = "H\195\164uptling Ukorz Sandw\195\188ter",
		["Gahz'rilla"] = "Gahz'rilla",
		["Hydromancer Velratha"] = "Wasserbeschw\195\182rerin Velratha",
		["Nekrum Gutchewer"] = "Nekrum der Ausweider",
		["Ruuzlu"] = "Ruuzlu",
		["Sandfury Executioner"] = "Henker der Sandw\195\188ter",
		["Sergeant Bly"] = "Unteroffizier Bly",
		["Theka the Martyr"] = "Theka der M\195\164rtyrer",
		["Witch Doctor Zum'rah"] = "Hexendoktor Zum'rah" ,
		["Zerillis"] = "Zerillis",
		["Zul'Farrak Dead Hero"] = "Untoter Held aus Zul'Farrak",

--Zul'Gurub
		["Bloodlord Mandokir"] = "Blutf\195\188rst Mandokir",
		["Gahz'ranka"] = "Gahz'ranka",
		["Gri'lek"] = "Gri'lek",
		["Hakkar"] = "Hakkar",
		["Hazza'rah"] = "Hazza'rah",
		["High Priestess Arlokk"] = "Hohepriesterin Arlokk",
		["High Priestess Jeklik"] = "Hohepriesterin Jeklik",
		["High Priestess Mar'li"] = "Hohepriesterin Mar'li",
		["High Priest Thekal"] = "Hohepriester Thekal",
		["High Priest Venoxis"] = "Hohepriester Venoxis",
		["Jin'do the Hexxer"] = "Jin'do der Verhexer",
		["Renataki"] = "Renataki",
		["Wushoolay"] = "Wushoolay",
} end)

BabbleBoss:RegisterTranslations("frFR", function() return {
		["Avalanchion"] = "Avalanchion",
		["The Windreaver"] = "Ouraganien",
		["Baron Charr"] = "Baron Charr",
		["Princess Tempestria"] = "Princesse Tempestria",
		["Onyxia"] = "Onyxia",
		["Azuregos"] = "Azuregos",
		["Ysondre"] = "Ysondre",
		["Emeriss"] = "Emeriss",
		["Taerar"] = "Taerar",
		["Lethon"] = "Léthon",
		["Ayamiss the Hunter"] = "Ayamiss le Chasseur",
		["Buru the Gorger"] = "Buru Grandgosier",
		["General Rajaxx"] = "Général Rajaxx",
		["Lieutenant General Andorov"] = "Général de division Andorov",
		["Moam"] = "Moam",
		["Anubisath Guardian"] = "Gardien Anubisath",
		["Ossirian the Unscarred"] = "Ossirian l'Intouché",
		["Alzzin the Wildshaper"] = "Alzzin le Modeleur",
		["Ambassador Flamelash"] = "Ambassadeur Cinglefouet",
		["Anger'rel"] = "Colé'rel",
		["Archivist Galford"] = "Archiviste Galford",
		["Bael'Gar"] = "Bael'Gar",
		["Balnazzar"] = "Balnazzar",
		["Baroness Anastari"] = "Baronne Anastari",
		["Baron Rivendare"] = "Baron Vaillefendre",
		["Cannon Master Willey"] = "Maître canonnier Willey",
		["Captain Kromcrush"] = "Capitaine Kromcrush",
		["Crystal Fang"] = "Croc cristallin",
		["Darkmaster Gandling"] = "Sombre Maître Gandling",
		["Doctor Theolen Krastinov"] = "Docteur Theolen Krastinov",
		["Doom'rel"] = "Tragi'rel",
		["Dope'rel"] = "Demeu'rel",
		["Emperor Dagran Thaurissan"] = "Empereur Dagran Thaurissan",
		["Fineous Darkvire"] = "Fineous Sombrevire",
		["Gasher"] = "Gasher",
		["General Angerforge"] = "Général Forgehargne",
		["General Drakkisath"] = "Général Drakkisath",
		["Gloom'rel"] = "Funéb'rel",
		["Golem Lord Argelmach"] = "Seigneur golem Argelmach",
		["Goraluk Anvilcrack"] = "Goraluk Brisenclume",
		["Guard Fengus"] = "Garde Fengus",
		["Guard Mol'dar"] = "Garde Mol'dar",
		["Guard Slip'kik"] = "Garde Slip'kik",
		["Gyth"] = "Gyth",
		["Halycon"] = "Halycon",
		["Hate'rel"] = "Haine'rel",
		["Hearthsinger Forresten"] = "Chanteloge Forrestin",
		["High Interrogator Gerstahn"] = "Grand Interrogateur Gerstahn",
		["Highlord Omokk"] = "Généralissime Omokk",
		["Hukku"] = "Hukku",
		["Hurley Blackbreath"] = "Hurley Soufflenoir",
		["Hydrospawn"] = "Hydrogénos",
		["Illyanna Ravenoak"] = "Illyanna Corvichêne",
		["Immol'thar"] = "Immol'thar",
		["Instructor Malicia"] = "Instructeur Malicia",
		["Jandice Barov"] = "Jandice Barov",
		["King Gordok"] = "Roi Gordok",
		["Kirtonos the Herald"] = "Kirtonos le Héraut",
		["Lady Illucia Barov"] = "Dame Illucia Barov",
		["Lethtendris"] = "Lethtendris",
		["Lord Alexei Barov"] = "Seigneur Alexei Barov",
		["Lord Incendius"] = "Seigneur Incendius",
		["Lord Valthalak"] = "Seigneur Valthalak",
		["Lorekeeper Polkelt"] = "Gardien du savoir Polkelt",
		["Loro"] = "Loro",
		["Magister Kalendris"] = "Magistère Kalendris",
		["Magistrate Barthilas"] = "Magistrat Barthilas",
		["Magmus"] = "Magmus",
		["Maleki the Pallid"] = "Maleki le Blafard",
		["Marduk Blackpool"] = "Marduk Noirétang",
		["Mijan"] = "Mijan",
		["Mother Smolderweb"] = "Matriarche Couveuse",
		["Nerub'enkan"] = "Nerub'enkan",
		["Overlord Wyrmthalak"] = "Seigneur Wyrmthalak",
		["Phalanx"] = "Phalange",
		["Plugger Spazzring"] = "Lanfiche Brouillecircuit",
		["Postmaster Malown"] = "Postier Malown",
		["Princess Moira Bronzebeard"] = "Princesse Moira Barbe-de-bronze",
		["Prince Tortheldrin"] = "Prince Tortheldrin",
		["Pusillin"] = "Pusillin",
		["Pyroguard Emberseer"] = "Pyrogarde Prophète ardent",
		["Ramstein the Gorger"] = "Ramstein Grandgosier",
		["Ras Frostwhisper"] = "Ras Murmegivre",
		["Rattlegore"] = "Cliquettripes",
		["Warchief Rend Blackhand"] = "Chef de guerre Rend Main-noire",
		["Ribbly Screwspigot"] = "Ribbly Fermevanne",
		["Seeth'rel"] = "Fulmi'rel",
		["Shadow Hunter Vosh'gajin"] = "Chasseresse des ombres Vosh'gajin",
		["Solakar Flamewreath"] = "Solakar Voluteflamme",
		["Stomper Kreeg"] = "Kreeg le Marteleur",
		["Tendris Warpwood"] = "Tendris Crochebois",
		["The Beast"] = "La Bête",
		["The Ravenian"] = "Le Voracien",
		["Timmy the Cruel"] = "Timmy le Cruel",
		["Tsu'zee"] = "Tsu'zee",
		["Vectus"] = "Vectus",
		["Vile'rel"] = "Ignobl'rel",
		["War Master Voone"] = "Maître de guerre Voone",
		["Zevrim Thornhoof"] = "Zevrim Sabot-de-ronce",
		["Zolo"] = "Zolo",
		["Zul'Lor"] = "Zul'Lor",

		-- From Mendeleev
		["Cho'Rush the Observer"] = "Cho'Rush l'Observateur",
		["Lord Hel'nurath"] = "Seigneur Hel'nurath",
		["Pimgib"] = "Pimgib",
		["Knot Thimblejack's Cache"] = "Réserve de Noué Dédodevie",
		["Archmage Arugal"] = "Archimage Arugal",
		["Arugal's Voidwalker"] = "Marcheur du Vide d'Arugal",
		["Baron Silverlaine"] = "Baron d'Argelaine",
		["Commander Springvale"] = "Commandant Springvale",
		["Deathsworn Captain"] = "Capitaine Ligemort",
		["Fenrus the Devourer"] = "Fenrus le Dévoreur",
		["Odo the Blindwatcher"] = "Odo l'Aveugle",
		["Razorclaw the Butcher"] = "Tranchegriffe le Boucher",
		["Wolf Master Nandos"] = "Maître-loup Nandos",
		["Kurinnaxx"] = "Kurinnaxx",

		-- OUTLANDS
		-- XXX: These are subject to change and may not be correct.
		["Doom Lord Kazzak"] = "Seigneur funeste Kazzak",
		["Doomwalker"] = "Marche-funeste",

		-- Karazhan
		["Prince Malchezaar"] = "Prince Malchezaar",
		["Attumen the Huntsman"] = "Attumen le Veneur",
		["Midnight"] = "Minuit",
		["Hyakiss the Lurker"] = "Hyakiss le rôdeur",
		["Rokad the Ravager"] = "Rodak le ravageur",
		["Shadikith the Glider"] = "Shadikith le glisseur",
		["Moroes"] = "Moroes",
		["Maiden of Virtue"] = "Damoiselle de vertu",
		["Dorothee"] = "Dorothée",
		["Tito"] = "Tito",
		["Tinhead"] = "Tête de fer-blanc",
		["Strawman"] = "Homme de paille",
		["Roar"] = "Graou",
		["The Crone"] = "La Mégère",
		["Romulo"] = "Romulo",
		["Julianne"] = "Julianne",
		["Romulo & Julianne"] = "Romulo & Julianne",
		["The Big Bad Wolf"] = "Le Grand Méchant Loup",
		["Grandmother"] = "Mère-grand",
		["The Curator"] = "Le conservateur",
		["Shade of Aran"] = "Ombre d'Aran",
		["Terestian Illhoof"] = "Terestian Malsabot",
		["Kil'rek"] = "Kil'rek",
		["Netherspite"] = "Dédain-du-Néant",
		["Nightbane"] = "Plaie-de-nuit",
		["Restless Skeleton"] = "Squelette sans repos",
		["Arcane Watchman"] = "Veilleur arcanique",
		["Chess Event"] = "Partie d'échec",
		["King Llane Piece"] = "Pion du Roi Llane",
		["Warchief Blackhand Piece"] = "Pion du Chef de guerre Main-noire",
		-- Caverns of Time
		--   Durnholde Keep
		["Lieutenant Drake"] = "Lieutenant Drake",
		["Captain Skarloc"] = "Capitaine Skarloc",
		["Epoch Hunter"] = "Chasseur d'époques",
		--   The Black Morass
		["Medivh"] = "Medivh",
		["Chrono Lord Deja"] = "Chronoseigneur Déjà",
		["Temporus"] = "Temporus",
		["Aeonus"] = "Aeonus",
		--   Battle of Mount Hyjal (subject to change)
		["Rage Winterchill"] = "Rage Froidhiver",
		["Anetheron"] = "Anetheron",
		["Kaz'rogal"] = "Kaz'rogal",
		["Azgalor"] = "Azgalor",
		["Archimonde"] = "Archimonde",
		-- Magtheridon's Lair
		["Magtheridon"] = "Magtheridon",
		["Hellfire Channeler"] = "Canaliste des Flammes infernales",
		-- The Underbog
		["Hungarfen"] = "Hungarfen",
		["Ghaz'an"] = "Ghaz'an",
		["Overseer Tidewrath"] = "Surveillant Tidewrath",
		["Claw"] = "Griffe",
		["Swamplord Musel'ek"] = "Seigneur des marais Musel'ek",
		["The Black Stalker"] = "La Traqueuse noire",
		-- The Steamvault
		["Hydromancer Thespia"] = "Hydromancienne Thespia",
		["Mekgineer Steamrigger"] = "Mékgénieur Montevapeur",
		["Warlord Kalithresh"] = "Seigneur de guerre Kalithresh",
		-- Mana Tombs
		["Pandemonius"] = "Pandemonius",
		["Tavarok"] = "Tavarok",
		["Nexus-Prince Shaffar"] = "Prince-nexus Shaffar",
		-- Auchenai Crypts
		["Shirrak the Dead Watcher"] = "Shirrak le Veillemort",
		["Exarch Maladaar"] = "Exarque Maladaar",
		-- Sethekk Halls
		["Talon King Ikiss"] = "Roi-serre Ikiss",
		["Darkweaver Syth"] = "Tisseur d'ombre Syth",
		-- The Mechanar
		["Gatewatcher Gyro-Kill"] = "Gardien de porte Gyro-Meurtre",
		["Nethermancer Sepethrea"] = "Néantomancien Sepethrea",
		["Gatewatcher Iron-Hand"] = "Gardien de porte Main-en-fer",
		["Mechano-Lord Capacitus"] = "Mécano-seigneur Capacitus",
		["Pathaleon the Calculator"] = "Pathaleon le Calculateur",
		-- The Botanica
		["Commander Sarannis"] = "Commandant Sarannis",
		["High Botanist Freywinn"] = "Grand botaniste Freywinn",
		["Thorngrin the Tender"] = "Rirépine le Tendre",
		["Laj"] = "Laj",
		["Warp Splinter"] = "Brise-dimension",
		-- The Arcatraz
		["Zereketh the Unbound"] = "Zereketh le Délié",
		["Wrath-Scryer Soccothrates"] = "Scrute-courroux Soccothrates",
		["Dalliah the Doomsayer"] = "Dalliah l'Auspice-funeste",
		["Harbinger Skyriss"] = "Messager Cieuriss",
		["Warden Mellichar"] = "Gardien Mellichar",
		-- The Eye
		["Kael'thas Sunstrider"] = "Kael'thas Haut-soleil",
		["Thaladred the Darkener"] = "Thaladred l'Assombrisseur",
		["Master Engineer Telonicus"] = "Maître ingénieur Telonicus",
		["Grand Astromancer Capernian"] = "Grand astromancien Capernian",
		["Lord Sanguinar"] = "Seigneur Sanguinar",
		["Al'ar"] = "Al'ar",
		["High Astromancer Solarian"] = "Grande astromancienne Solarian",
		["Solarium Agent"] = "Agent du Solarium",
		["Solarium Priest"] = "Prêtre du Solarium",
		["Void Reaver"] = "Saccageur du Vide",
		["Devastation"] = "Dévastation",
		["Cosmic Infuser"] = "Bâton d'infusion cosmique",
		["Infinity Blades"] = "Lames d'infinité",
		["Staff of Disintegration"] = "Bâton de désintégration",
		["Warp Slicer"] = "Tranchoir dimensionnel",
		["Netherstrand Longbow"] = "Arc long brins-de-Néant",
		["Phaseshift Bulwark"] = "Rempart de déphasage",
		-- Ring of Blood
		["Brokentoe"] = "Brisorteil",
		["Murkblood Twin"] = "Jumeau bourbesang",
		["Murkblood Twins"] = "Jumeaux bourbesang",
		["The Blue Brothers"] = "Les Grands Bleus",
		["Rokdar the Sundered Lord"] = "Rokdar le Seigneur scindé",
		["Skra'gath"] = "Skra'gath",
		["Warmaul Champion"] = "Champion Cogneguerre",
		["Mogor"] = "Mogor",

--[[    New Format Separator    ]]

--Ahn'Qiraj
		["Anubisath Defender"] = "Défenseur Anubisath",
		["Battleguard Sartura"] = "Garde de guerre Sartura",
		["C'Thun"] = "C'Thun",
		["Emperor Vek'lor"] = "Empereur Vek'lor",
		["Emperor Vek'nilash"] = "Empereur Vek'nilash",
		["Eye of C'Thun"] = "Œil de C'Thun",
		["Fankriss the Unyielding"] = "Fankriss l'Inflexible",
		["Lord Kri"] = "Seigneur Kri",
		["Ouro"] = "Ouro",
		["Princess Huhuran"] = "Princesse Huhuran",
		["Princess Yauj"] = "Princesse Yauj",
		["The Bug Family"] = "La famille insecte",
		["The Prophet Skeram"] = "Le Prophète Skeram",
		["The Twin Emperors"] = "Les Empereurs jumeaux",
		["Vem"] = "Vem",
		["Viscidus"] = "Viscidus",

--Black Temple
		["Illidan Stormrage"] = "Illidan Hurlorage",
		["Mother Shahraz"] = "Mère Shahraz",
		["The Illidari Council"] = "Le conseil Illidari",
		["Lady Malande"] = "Dame Malande",
		["High Warlord Naj'entus"] = "Grand seigneur de guerre Naj'entus",
		["Teron Gorefiend"] = "Teron Fielsang",
		["Gathios the Shatterer"] = "Gathios le Briseur",
		["Veras Darkshadow"] = "Veras Ombrenoir",
		["Gurtogg Bloodboil"] = "Gurtogg Fièvresang",
		["High Nethermancer Zerevor"] = "Grand néantomancien Zerevor",
		["Essence of Desire"] = "Essence du désir", -- à vérifier
		["Essence of Suffering"] = "Essence de souffrance", -- à vérifier
		["Essence of Anger"] = "Essence de colère", -- à vérifier
		["Reliquary of Souls"] = "Reliquaire des âmes",
		["Supremus"] = "Supremus",
		["Shade of Akama"] = "Ombre d'Akama",

--Blackfathom Deeps
		["Aku'mai"] = "Aku'mai",
		["Baron Aquanis"] = "Baron Aquanis",
		["Gelihast"] = "Gelihast",
		["Ghamoo-ra"] = "Ghamoo-ra",
		["Lady Sarevess"] = "Dame Sarevess",
		["Twilight Lord Kelris"] = "Seigneur du crépuscule Kelris",
		["Old Serra'kis"] = "Vieux Serra'kis",

--Blackrock Depths
		["Anub'shiah"] = "Anub'shiah",
		["Gorosh the Dervish"] = "Gorosh le Derviche",
		["Grizzle"] = "Grison",
		["Hedrum the Creeper"] = "Hedrum le Rampant",
		["High Priestess of Thaurissan"] = "Grande prêtresse de Thaurissan",
		["Houndmaster Grebmar"] = "Maître-chien Grebmar",
		["Lord Roccor"] = "Seigneur Roccor",
		["Ok'thor the Breaker"] = "Ok'thor le Briseur",
		["Panzor the Invincible"] = "Panzor l'Invincible",
		["The Seven Dwarves"] = "Les sept nains",
		["Verek"] = "Verek",
		["Warder Stilgiss"] = "Gardien Stilgiss",

--Blackwing Lair
		["Broodlord Lashlayer"] = "Seigneur des couvées Lanistaire",
		["Chromaggus"] = "Chromaggus",
		["Ebonroc"] = "Rochébène",
		["Firemaw"] = "Gueule-de-feu",
		["Flamegor"] = "Flamegor",
		["Grethok the Controller"] = "Grethok le Contrôleur",
		["Lord Victor Nefarius"] = "Seigneur Victor Nefarius",
		["Nefarian"] = "Nefarian",
		["Razorgore the Untamed"] = "Tranchetripe l'Indompté",
		["Vaelastrasz the Corrupt"] = "Vaelastrasz le Corrompu",

--Gnomeregan
		["Crowd Pummeler 9-60"] = "Faucheur de foule 9-60",
		["Dark Iron Ambassador"] = "Ambassadeur Sombrefer",
		["Electrocutioner 6000"] = "Electrocuteur 6000",
		["Grubbis"] = "Grubbis",
		["Mekgineer Thermaplugg"] = "Mekgénieur Thermojoncteur",
		["Techbot"] = "Techbot",
		["Viscous Fallout"] = "Retombée visqueuse",

--Gruul's Lair
		["Gruul the Dragonkiller"] = "Gruul le Tue-dragon",
		["High King Maulgar"] = "Haut Roi Maulgar",
		["Kiggler the Crazed"] = "Kiggler le Cinglé",
		["Blindeye the Seer"] = "Oeillaveugle le Voyant",
		["Olm the Summoner"] = "Olm l'Invocateur",
		["Krosh Firehand"] = "Krosh Brasemain",

--Hellfire Ramparts
		["Nazan"] = "Nazan",
		["Omor the Unscarred"] = "Omor l'Intouché",
		["Vazruden"] = "Vazruden",
		["Vazruden the Herald"] = "Vazruden le Héraut",
		["Watchkeeper Gargolmar"] = "Gardien des guetteurs Gargolmar",

--Maraudon
		["Celebras the Cursed"] = "Celebras le Maudit",
		["Gelk"] = "Gelk",
		["Kolk"] = "Kolk",
		["Landslide"] = "Glissement de terrain",
		["Lord Vyletongue"] = "Seigneur Vylelangue",
		["Magra"] = "Magra",
		["Maraudos"] = "Maraudos",
		["Meshlok the Harvester"] = "Meshlok le Moissonneur",
		["Noxxion"] = "Noxcion",
		["Princess Theradras"] = "Princesse Theradras",
		["Razorlash"] = "Tranchefouet",
		["Rotgrip"] = "Grippe-charogne",
		["Tinkerer Gizlock"] = "Bricoleur Kadenaz",
		["Veng"] = "Veng",

--Molten Core
		["Baron Geddon"] = "Baron Geddon",
		["Garr"] = "Garr",
		["Gehennas"] = "Gehennas",
		["Golemagg the Incinerator"] = "Golemagg l'Incinérateur",
		["Lucifron"] = "Lucifron",
		["Magmadar"] = "Magmadar",
		["Majordomo Executus"] = "Chambellan Executus",
		["Ragnaros"] = "Ragnaros",
		["Shazzrah"] = "Shazzrah",
		["Sulfuron Harbinger"] = "Messager de Sulfuron",

--Naxxramas
		["Anub'Rekhan"] = "Anub'Rekhan",
		["Deathknight Understudy"] = "Doublure de chevalier de la mort",
		["Feugen"] = "Feugen",
		["Gluth"] = "Gluth",
		["Gothik the Harvester"] = "Gothik le Moissonneur",
		["Grand Widow Faerlina"] = "Grande veuve Faerlina",
		["Grobbulus"] = "Grobbulus",
		["Heigan the Unclean"] = "Heigan l'Impur",
		["Highlord Mograine"] = "Généralissime Mograine",
		["Instructor Razuvious"] = "Instructeur Razuvious",
		["Kel'Thuzad"] = "Kel'Thuzad",
		["Lady Blaumeux"] = "Dame Blaumeux",
		["Loatheb"] = "Horreb",
		["Maexxna"] = "Maexxna",
		["Noth the Plaguebringer"] ="Noth le Porte-peste",
		["Patchwerk"] = "Le Recousu",
		["Sapphiron"] = "Sapphiron",
		["Sir Zeliek"] = "Sire Zeliek ",
		["Stalagg"] = "Stalagg",
		["Thaddius"] = "Thaddius",
		["Thane Korth'azz"] = "Thane Korth'azz",
		["The Four Horsemen"] = "Les 4 Cavaliers",

--Ragefire Chasm
		["Bazzalan"] = "Bazzalan",
		["Jergosh the Invoker"] = "Jergosh l'Invocateur",
		["Maur Grimtotem"] = "Maur Totem-sinistre",
		["Taragaman the Hungerer"] = "Taragaman l'Affameur",

--Razorfen Downs
		["Amnennar the Coldbringer"] = "Amnennar le Porte-froid",
		["Glutton"] = "Glouton",
		["Mordresh Fire Eye"] = "Mordresh Oeil-de-feu",
		["Plaguemaw the Rotting"] = "Pestegueule le Pourrissant",
		["Ragglesnout"] = "Groinfendu",
		["Tuten'kash"] = "Tuten'kash",

--Razorfen Kraul
		["Agathelos the Raging"] = "Agathelos le Déchaîné",
		["Blind Hunter"] = "Chasseur aveugle",
		["Charlga Razorflank"] = "Charlga Trancheflanc",
		["Death Speaker Jargba"] = "Nécrorateur Jargba",
		["Earthcaller Halmgar"] = "Implorateur de la terre Halmgar",
		["Overlord Ramtusk"] = "Seigneur Brusquebroche",

--Scarlet Monastery
		["Arcanist Doan"] = "Arcaniste Doan",
		["Azshir the Sleepless"] = "Azshir le Sans-sommeil",
		["Bloodmage Thalnos"] = "Mage de sang Thalnos",
		["Fallen Champion"] = "Champion mort",
		["Herod"] = "Herod",
		["High Inquisitor Fairbanks"] = "Grand Inquisiteur Fairbanks",
		["High Inquisitor Whitemane"] = "Grand Inquisiteur Blanchetête",
		["Houndmaster Loksey"] = "Maître-chien Loksey",
		["Interrogator Vishas"] = "Interrogateur Vishas",
		["Ironspine"] = "Echine-de-fer",
		["Scarlet Commander Mograine"] = "Commandant écarlate Mograine",

--Serpentshrine Cavern
		["Hydross the Unstable"] = "Hydross l'Instable",
		["Tainted Spawn of Hydross"] = "Rejeton d'Hydross souillé",
		["Pure Spawn of Hydross"] = "Pur rejeton d'Hydross",
		["Fathom-Lord Karathress"] = "Seigneur des fonds Karathress",
		["Morogrim Tidewalker"] = "Morogrim Marcheur-des-flots",
		["Tidewalker Lurker"] = "Rôdeur marcheur-des-flots",
		["Leotheras the Blind"] = "Leotheras l'Aveugle",
		["Shadow of Leotheras"] = "Ombre de Leotheras",
		["Lady Vashj"] = "Dame Vashj",
		["Coilfang Elite"] = "Elite de Glissecroc",
		["Coilfang Strider"] = "Trotteur de Glissecroc",
		["The Lurker Below"] = "Le Rôdeur d'En-bas",

--Shadow Labyrinth
		["Ambassador Hellmaw"] = "Ambassadeur Gueule-d'enfer",
		["Blackheart the Inciter"] = "Coeur-noir le Séditieux",
		["Grandmaster Vorpil"] = "Grand Maître Vorpil",
		["Murmur"] = "Marmon",

--The Blood Furnace
		["Broggok"] = "Broggok",
		["Keli'dan the Breaker"] = "Keli'dan le Briseur",
		["The Maker"] = "Le Faiseur",

--The Deadmines
		["Brainwashed Noble"] = "Noble manipulé",
		["Captain Greenskin"] = "Capitaine Vertepeau",
		["Cookie"] = "Macaron",
		["Edwin VanCleef"] = "Edwin VanCleef",
		["Gilnid"] = "Gilnid",
		["Marisa du'Paige"] = "Marisa du'Paige",
		["Miner Johnson"] = "Mineur Johnson",
		["Mr. Smite"] = "M. Châtiment",
		["Rhahk'Zor"] = "Rhahk'Zor",
		["Sneed"] = "Sneed",
		["Sneed's Shredder"] = "Déchiqueteur de Sneed",

--The Shattered Halls
		["Grand Warlock Nethekurse"] = "Grand démoniste Néanathème",
		["Warbringer O'mrogg"] = "Porteguerre O'mrogg",
		["Warchief Kargath Bladefist"] = "Chef de guerre Kargath Lamepoing",
		["Blood Guard Porung"] = "Garde de sang Porung",

--The Slave Pens
		["Mennu the Betrayer"] = "Mennu le Traître",
		["Quagmirran"] = "Bourbierreux",
		["Rokmar the Crackler"] = "Rokmar le Crépitant",

--The Stockade
		["Bazil Thredd"] = "Bazil Thredd",
		["Bruegal Ironknuckle"] = "Bruegal Poing-de-fer",
		["Dextren Ward"] = "Dextren Ward",
		["Hamhock"] = "Hamhock",
		["Kam Deepfury"] = "Kam Furie-du-fond",
		["Targorr the Dread"] = "Targorr le Terrifiant",

--The Temple of Atal'Hakkar
		["Atal'alarion"] = "Atal'alarion",
		["Avatar of Hakkar"] = "Avatar d'Hakkar",
		["Dreamscythe"] = "Fauche-rêve",
		["Hazzas"] = "Hazzas",
		["Jammal'an the Prophet"] = "Jammal'an le prophète",
		["Morphaz"] = "Morphaz",
		["Ogom the Wretched"] = "Ogom le Misérable",
		["Shade of Eranikus"] = "Ombre d'Eranikus",
		["Weaver"] = "Tisserand",

--Uldaman
		["Ancient Stone Keeper"] = "Ancien Gardien des pierres",
		["Archaedas"] = "Archaedas",
		["Baelog"] = "Baelog",
		["Digmaster Shovelphlange"] = "Maître des fouilles Pellaphlange",
		["Galgann Firehammer"] = "Galgann Martel-de-feu",
		["Grimlok"] = "Grimlok",
		["Ironaya"] = "Ironaya",
		["Obsidian Sentinel"] = "Sentinelle d'obsidienne",
		["Revelosh"] = "Revelosh",

--Wailing Caverns
		["Boahn"] = "Boahn",
		["Deviate Faerie Dragon"] = "Dragon féérique déviant",
		["Kresh"] = "Kresh",
		["Lady Anacondra"] = "Dame Anacondra",
		["Lord Cobrahn"] = "Seigneur Cobrahn",
		["Lord Pythas"] = "Seigneur Pythas",
		["Lord Serpentis"] = "Seigneur Serpentis",
		["Mad Magglish"] = "Magglish le Dingue",
		["Mutanus the Devourer"] = "Mutanus le Dévoreur",
		["Skum"] = "Skum",
		["Trigore the Lasher"] = "Trigore le Flagelleur",
		["Verdan the Everliving"] = "Verdan l'Immortel",

--World Bosses
		["Baron Kazum"] = "Baron Kazum",
		["High Marshal Whirlaxis"] = "Haut maréchal Trombe",
		["Lord Skwol"] = "Seigneur Skwol",

--Zul'Aman
		["Warlord Jin'Zakk"] = "Seigneur de guerre Jin'Zakk",

--Zul'Farrak
		["Antu'sul"] = "Antu'sul",
		["Chief Ukorz Sandscalp"] = "Chef Ukorz Scalpessable",
		["Gahz'rilla"] = "Gahz'rilla",
		["Hydromancer Velratha"] = "Hydromancienne Velratha",
		["Nekrum Gutchewer"] = "Nekrum Mâchetripes",
		["Ruuzlu"] = "Ruuzlu",
		["Sandfury Executioner"] = "Bourreau Furie-des-sables",
		["Sergeant Bly"] = "Sergent Bly",
		["Theka the Martyr"] = "Theka le Martyr",
		["Witch Doctor Zum'rah"] = "Sorcier-docteur Zum'rah",
		["Zerillis"] = "Zerillis",
		["Zul'Farrak Dead Hero"] = "Héros mort de Zul'Farrak",

--Zul'Gurub
		["Bloodlord Mandokir"] = "Seigneur sanglant Mandokir",
		["Gahz'ranka"] = "Gahz'ranka",
		["Gri'lek"] = "Gri'lek",
		["Hakkar"] = "Hakkar",
		["Hazza'rah"] = "Hazza'rah",
		["High Priestess Arlokk"] = "Grande prêtresse Arlokk",
		["High Priestess Jeklik"] = "Grande prêtresse Jeklik",
		["High Priestess Mar'li"] = "Grande prêtresse Mar'li",
		["High Priest Thekal"] = "Grand prêtre Thekal",
		["High Priest Venoxis"] = "Grand prêtre Venoxis",
		["Jin'do the Hexxer"] = "Jin'do le Maléficieur",
		["Renataki"] = "Renataki",
		["Wushoolay"] = "Wushoolay",
	} end)


-- Translater CWDG 急云   校对 月色狼影
-- CWDG Sie Web: http://cwowaddon.com
-- CWDG: CWoW Developer Group
BabbleBoss:RegisterTranslations("zhCN", function() return {
		["Avalanchion"] = "\233\152\191\231\147\166\229\133\176\229\165\135\229\165\165",
		["The Windreaver"] = "\231\131\136\233\163\142\230\142\160\229\164\186\232\128\133",
		["Baron Charr"] = "\231\129\171\231\132\176\231\148\183\231\136\181\230\159\165\229\176\148",
		["Princess Tempestria"] = "\230\179\176\230\175\148\230\150\175\232\146\130\228\186\154\229\133\172\228\184\187",
		["Onyxia"] = "\229\165\165\229\166\174\229\133\139\229\184\140\228\186\154",
		["Azuregos"] = "\232\137\190\231\180\162\233\155\183\232\145\155\230\150\175",
		["Ysondre"] = "\228\188\138\230\163\174\229\190\183\233\155\183",
		["Emeriss"] = "\232\137\190\232\142\171\232\142\137\228\184\157",
		["Taerar"] = "\230\179\176\230\139\137\229\176\148",
		["Lethon"] = "\232\142\177\231\180\162\230\129\169",
		["Ayamiss the Hunter"] = "\231\139\169\231\140\142\232\128\133\233\152\191\228\186\154\231\177\179\230\150\175",
		["Buru the Gorger"] = "\229\144\158\229\146\189\232\128\133\229\184\131\233\178\129",
		["General Rajaxx"] = "\230\139\137\232\180\190\229\133\139\230\150\175\229\176\134\229\134\155",
		["Lieutenant General Andorov"] = "\229\174\137\229\164\154\230\180\155\229\164\171\228\184\173\229\176\134",
		["Moam"] = "\232\142\171\233\152\191\229\167\134",
		["Anubisath Guardian"] = "\233\152\191\229\138\170\230\175\148\232\144\168\230\150\175\229\174\136\229\141\171\232\128\133",
		["Ossirian the Unscarred"] = "\230\151\160\231\150\164\232\128\133\229\165\165\230\150\175\233\135\140\229\174\137",
		["Alzzin the Wildshaper"] = "\229\165\165\229\133\185\230\129\169",
		["Ambassador Flamelash"] = "\229\188\151\232\142\177\230\139\137\230\150\175\229\164\167\228\189\191",
		["Anger'rel"] = "\229\174\137\230\160\188\233\155\183\229\176\148",
		["Archivist Galford"] = "\230\161\163\230\161\136\231\174\161\231\144\134\229\145\152\229\138\160\229\176\148\231\166\143\231\137\185",
		["Bael'Gar"] = "\232\180\157\229\176\148\229\138\160",
		["Balnazzar"] = "\229\183\180\231\186\179\230\137\142\229\176\148",
		["Baroness Anastari"] = "\229\174\137\229\168\156\228\184\157\229\161\148\228\184\189\231\148\183\231\136\181\229\164\171\228\186\186",
		["Baron Rivendare"] = "\231\145\158\230\150\135\230\136\180\229\176\148\231\148\183\231\136\181",
		["Cannon Master Willey"] = "\231\130\174\230\137\139\229\168\129\229\136\169",
		["Captain Kromcrush"] = "\229\133\139\231\189\151\229\141\161\230\150\175",
		["Crystal Fang"] = "\230\176\180\230\153\182\228\185\139\231\137\153",
		["Darkmaster Gandling"] = "\233\187\145\230\154\151\233\153\162\233\149\191\229\138\160\228\184\129",
		["Doctor Theolen Krastinov"] = "\231\145\159\229\176\148\230\158\151\194\183\229\141\161\230\150\175\232\191\170\232\175\186\229\164\171\230\149\153\230\142\136",
		["Doom'rel"] = "\230\157\156\229\167\134\233\155\183\229\176\148",
		["Dope'rel"] = "\229\164\154\230\153\174\233\155\183\229\176\148",
		["Emperor Dagran Thaurissan"] = "\232\190\190\230\160\188\229\133\176\194\183\231\180\162\231\145\158\230\163\174\229\164\167\229\184\157",
		["Fineous Darkvire"] = "\229\188\151\232\175\186\230\150\175\194\183\232\190\190\229\133\139\231\187\180\229\176\148",
		["Gasher"] = "\229\138\160\228\187\128\229\176\148",
		["General Angerforge"] = "\229\174\137\230\160\188\229\188\151\229\176\134\229\134\155",
		["General Drakkisath"] = "\232\190\190\229\159\186\232\144\168\230\150\175\229\176\134\229\134\155",
		["Gloom'rel"] = "\230\160\188\233\178\129\233\155\183\229\176\148",
		["Golem Lord Argelmach"] = "\229\130\128\229\132\161\231\187\159\229\184\133\233\152\191\230\160\188\230\155\188\229\165\135",
		["Goraluk Anvilcrack"] = "\229\143\164\230\139\137\233\178\129\229\133\139",
		["Guard Fengus"] = "\229\141\171\229\133\181\232\138\172\229\143\164\230\150\175",
		["Guard Mol'dar"] = "\229\141\171\229\133\181\230\145\169\229\176\148\232\190\190",
		["Guard Slip'kik"] = "\229\141\171\229\133\181\230\150\175\233\135\140\229\159\186\229\133\139",
		["Gyth"] = "\231\155\150\230\150\175",
		["Halycon"] = "\229\147\136\233\155\183\232\130\175",
		["Hate'rel"] = "\233\187\145\231\137\185\233\155\183\229\176\148",
		["Hearthsinger Forresten"] = "\229\188\151\233\155\183\230\150\175\231\137\185\230\129\169",
		["High Interrogator Gerstahn"] = "\229\174\161\232\174\175\229\174\152\230\160\188\230\150\175\229\161\148\230\129\169",
		["Highlord Omokk"] = "\230\172\167\232\142\171\229\133\139\229\164\167\231\142\139",
		["Hukku"] = "\232\131\161\229\186\147",
		["Hurley Blackbreath"] = "\233\156\141\229\176\148\233\155\183\194\183\233\187\145\233\161\187",
		["Hydrospawn"] = "\230\181\183\229\164\154\230\150\175\229\141\154\230\129\169",
		["Illyanna Ravenoak"] = "\228\188\138\231\144\179\229\168\156\194\183\230\154\151\230\156\168",
		["Immol'thar"] = "\228\188\138\232\142\171\229\161\148\229\176\148",
		["Instructor Malicia"] = "\232\174\178\229\184\136\231\142\155\228\184\189\229\184\140\228\186\154",
		["Jandice Barov"] = "\232\169\185\232\191\170\230\150\175\194\183\229\183\180\231\189\151\229\164\171",
		["King Gordok"] = "\230\136\136\229\164\154\229\133\139\229\164\167\231\142\139",
		["Kirtonos the Herald"] = "\228\188\160\228\187\164\229\174\152\229\159\186\229\176\148\229\155\190\232\175\186\230\150\175",
		["Lady Illucia Barov"] = "\228\188\138\233\156\178\229\184\140\228\186\154\194\183\229\183\180\231\189\151\229\164\171",
		["Lethtendris"] = "\232\149\190\231\145\159\229\161\148\232\146\130\228\184\157",
		["Lord Alexei Barov"] = "\233\152\191\233\155\183\229\133\139\230\150\175\194\183\229\183\180\231\189\151\229\164\171",
		["Lord Incendius"] = "\228\188\138\230\163\174\232\191\170\229\165\165\230\150\175",
		["Lord Valthalak"] = "\231\147\166\229\161\148\230\139\137\229\133\139\229\133\172\231\136\181",
		["Lorekeeper Polkelt"] = "\229\141\154\229\173\166\232\128\133\230\153\174\229\133\139\229\176\148\231\137\185",
		["Loro"] = "\230\180\155\232\139\165\229\176\148",
		["Magister Kalendris"] = "\229\141\161\233\155\183\232\191\170\230\150\175\233\149\135\233\149\191",
		["Magistrate Barthilas"] = "\229\183\180\231\145\159\230\139\137\230\150\175\233\149\135\233\149\191",
		["Magmus"] = "\231\142\155\230\160\188\229\167\134\230\150\175",
		["Maleki the Pallid"] = "\232\139\141\231\153\189\231\154\132\231\142\155\229\139\146\229\159\186",
		["Marduk Blackpool"] = "\233\169\172\230\157\156\229\133\139\194\183\229\184\131\232\142\177\229\133\139\230\179\162\229\176\148",
		["Mijan"] = "\231\177\179\230\157\137",
		["Mother Smolderweb"] = "\231\131\159\231\189\145\232\155\155\229\144\142",
		["Nerub'enkan"] = "\229\165\136\233\178\129\229\184\131\230\129\169\229\157\142",
		["Overlord Wyrmthalak"] = "\231\187\180\229\167\134\232\144\168\230\139\137\229\133\139",
		["Phalanx"] = "\230\150\185\233\152\181",
		["Plugger Spazzring"] = "\230\153\174\230\139\137\230\160\188",
		["Postmaster Malown"] = "\233\130\174\229\183\174\233\169\172\233\190\153",
		["Princess Moira Bronzebeard"] = "\233\147\129\231\130\137\229\160\161\229\133\172\228\184\187\232\140\137\232\137\190\230\139\137\194\183\233\147\156\233\161\187",
		["Prince Tortheldrin"] = "\230\137\152\229\161\158\229\190\183\230\158\151\231\142\139\229\173\144",
		["Pusillin"] = "\230\153\174\229\184\140\230\158\151",
		["Pyroguard Emberseer"] = "\231\131\136\231\132\176\229\141\171\229\163\171\232\137\190\229\141\154\229\184\140\229\176\148",
		["Ramstein the Gorger"] = "\229\144\158\229\146\189\232\128\133\230\139\137\229\167\134\230\150\175\231\153\187",
		["Ras Frostwhisper"] = "\232\142\177\230\150\175\194\183\233\156\156\232\175\173",
		["Rattlegore"] = "\232\161\128\233\170\168\229\130\128\229\132\161",
		["Warchief Rend Blackhand"] = "\229\164\167\233\133\139\233\149\191\233\155\183\229\190\183\194\183\233\187\145\230\137\139",
		["Ribbly Screwspigot"] = "\233\155\183\229\184\131\233\135\140\194\183\230\150\175\229\186\147\230\175\148\230\160\188\231\137\185",
		["Seeth'rel"] = "\232\165\191\230\150\175\233\155\183\229\176\148",
		["Shadow Hunter Vosh'gajin"] = "\230\154\151\229\189\177\231\140\142\230\137\139\230\178\131\228\187\128\229\138\160\230\150\175",
		["Solakar Flamewreath"] = "\231\180\162\230\139\137\229\141\161\194\183\231\129\171\229\134\160",
		["Stomper Kreeg"] = "\232\183\181\232\184\143\232\128\133\229\133\139\233\155\183\230\160\188",
		["Tendris Warpwood"] = "\231\137\185\232\191\170\230\150\175\194\183\230\137\173\230\156\168",
		["The Beast"] = "\230\175\148\230\150\175\229\183\168\229\133\189",
		["The Ravenian"] = "\230\139\137\230\150\135\229\176\188\228\186\154",
		["Timmy the Cruel"] = "\230\130\178\230\131\168\231\154\132\230\143\144\231\177\179",
		["Tsu'zee"] = "\232\139\143\230\150\175",
		["Vectus"] = "\231\187\180\229\133\139\229\155\190\230\150\175",
		["Vile'rel"] = "\231\147\166\229\139\146\233\155\183\229\176\148",
		["War Master Voone"] = "\230\140\135\230\140\165\229\174\152\230\178\131\230\129\169",
		["Zevrim Thornhoof"] = "\231\145\159\233\155\183\229\167\134\194\183\229\136\186\232\185\132",
		["Zolo"] = "\231\165\150\231\189\151",
		["Zul'Lor"] = "\231\165\150\231\189\151\229\176\148",

		-- From Mendeleev
		["Cho'Rush the Observer"] = "\232\167\130\229\175\159\232\128\133\229\133\139\233\178\129\228\187\128",
		["Lord Hel'nurath"] = "\232\181\171\229\176\148\229\138\170\230\139\137\230\150\175",
		["Pimgib"] = "\229\140\185\229\167\134\229\144\137\229\184\131",
		["Knot Thimblejack's Cache"] = "\232\175\186\231\137\185\194\183\229\184\140\229\167\134\229\138\160\229\133\139\231\154\132\229\130\168\231\137\169\231\174\177",
		["Archmage Arugal"] = "\229\164\167\230\179\149\229\184\136\233\152\191\233\178\129\233\171\152",
		["Arugal's Voidwalker"] = "\233\152\191\233\178\129\233\171\152\231\154\132\232\153\154\231\169\186\232\161\140\232\128\133",
		["Baron Silverlaine"] = "\229\184\173\231\147\166\232\142\177\230\129\169\231\148\183\231\136\181",
		["Commander Springvale"] = "\230\140\135\230\140\165\229\174\152\230\150\175\230\153\174\230\158\151\231\147\166\229\176\148",
		["Deathsworn Captain"] = "\230\173\187\228\186\161\228\185\139\232\170\147",
		["Fenrus the Devourer"] = "\229\144\158\229\153\172\232\128\133\232\138\172\233\178\129\230\150\175",
		["Odo the Blindwatcher"] = "\231\155\178\231\156\188\229\174\136\229\141\171\229\165\165\230\157\156",
		["Razorclaw the Butcher"] = "\229\177\160\229\164\171\230\139\137\228\189\144\229\133\139\229\138\179",
		["Wolf Master Nandos"] = "\231\139\188\231\142\139\229\141\151\230\157\156\230\150\175",
		["Kurinnaxx"] = "\229\186\147\230\158\151\231\186\179\229\133\139\230\150\175",

		-- OUTLANDS
		-- XXX: These are subject to change and may not be correct.
		["Doom Lord Kazzak"] = "\230\156\171\230\151\165\233\162\134\228\184\187\229\141\161\230\137\142\229\133\139",
		["Doomwalker"] = "\230\156\171\230\151\165\232\161\140\232\128\133",

		-- Karazhan
		["Prince Malchezaar"] = "玛克扎尔王子",
		["Attumen the Huntsman"] = "猎手阿图门",
		["Midnight"] = "午夜",
		["Hyakiss the Lurker"] = "潜伏者希亚其斯",
		["Rokad the Ravager"] = "蹂躏者洛卡德",
		["Shadikith the Glider"] = "滑翔者沙德基斯",
		["Moroes"] = "莫罗斯",
		["Maiden of Virtue"] = "贞节圣女",
		["Dorothee"] = "多萝茜",
		["Tito"] = "托托",
		["Tinhead"] = "铁皮人",
		["Strawman"] = "稻草人",
		["Roar"] = "胆小的狮子",
		["The Crone"] = "巫婆",
		["Romulo"] = "罗密欧",
		["Julianne"] = "朱丽叶",
		["Romulo & Julianne"] = "罗密欧与朱丽叶",
		["The Big Bad Wolf"] = "大灰狼",
		["Grandmother"] = "老奶奶",
		["The Curator"] = "馆长",
		["Shade of Aran"] = "埃兰之影",
		["Terestian Illhoof"] = "特雷斯坦·邪蹄",
		["Kil'rek"] = "基尔里克",
		["Netherspite"] = "虚空幽龙",
		["Nightbane"] = "夜之魇",
		["Restless Skeleton"] = "无法安息的骷髅",
		["King Llane Piece"] = "莱恩国王",
		["Warchief Blackhand Piece"] = "黑手酋长",
		["Arcane Watchman"] = "奥术看守",
		["Chess Event"] = "国际象棋",

		-- Caverns of Time
		--   Durnholde Keep
		["Lieutenant Drake"] = "\229\190\183\230\139\137\229\133\139\228\184\173\229\176\137",
		["Captain Skarloc"] = "\230\150\175\229\141\161\230\180\155\229\133\139\228\184\138\229\176\137",
		["Epoch Hunter"] = "\230\151\182\231\169\186\231\140\142\230\137\139",
		--   The Black Morass
		["Medivh"] = "\233\186\166\232\191\170\230\150\135",
		["Chrono Lord Deja"] = "\230\151\182\231\169\186\233\162\134\228\184\187\229\190\183\228\186\154",
		["Temporus"] = "\229\157\166\230\153\174\229\141\162\230\150\175",
		["Aeonus"] = "\229\159\131\230\172\167\229\138\170\230\150\175",
        --   Battle of Mount Hyjal (subject to change)
		["Rage Winterchill"] = "\233\155\183\229\159\186\194\183\229\134\172\229\175\146",
		["Anetheron"] = "\229\174\137\231\186\179\229\161\158\233\154\134",
		["Kaz'rogal"] = "\229\141\161\229\133\185\230\180\155\229\138\160",
		["Azgalor"] = "\233\152\191\229\133\185\229\138\160\230\180\155",
		--   XX
		["Archimonde"] = "\233\152\191\229\133\139\232\146\153\229\190\183",
		-- Magtheridon's Lair
		["Magtheridon"] = "\231\142\155\231\145\159\233\135\140\233\161\191",
		["Hellfire Channeler"] = "\229\156\176\231\139\177\231\129\171\229\175\188\233\173\148\232\128\133",
		-- The Underbog
		["Hungarfen"] = "\233\156\141\229\138\160\229\176\148\232\138\172",
		["Ghaz'an"] = "\229\138\160\229\133\185\229\174\137",
		["Overseer Tidewrath"] = "\229\183\165\229\164\180\230\179\176\229\190\183\231\147\166\230\150\175",
		["Claw"] = "\229\133\139\229\138\179\230\129\169",
		["Swamplord Musel'ek"] = "\230\178\188\229\156\176\233\162\134\228\184\187\231\169\134\229\161\158\233\155\183\229\133\139",
		["The Black Stalker"] = "\233\187\145\232\137\178\233\152\148\230\173\165\232\128\133",
		-- The Steamvault
		["Hydromancer Thespia"] = "\230\176\180\230\156\175\229\184\136\231\145\159\228\184\157\230\175\148\229\168\133",
		["Mekgineer Steamrigger"] = "\230\156\186\230\162\176\229\184\136\230\150\175\232\146\130\233\135\140\230\160\188",
		["Warlord Kalithresh"] = "\231\157\163\229\134\155\229\141\161\229\136\169\231\145\159\233\135\140\230\150\175",
		-- Mana Tombs
		["Pandemonius"] = "\230\189\152\229\190\183\232\142\171\229\138\170\230\150\175",
		["Tavarok"] = "Tavarok",
		["Nexus-Prince Shaffar"] = "\232\138\130\231\130\185\228\186\178\231\142\139\230\178\153\230\179\149\229\176\148",
		-- Auchenai Crypts
		["Shirrak the Dead Watcher"] = "\230\173\187\228\186\161\232\167\130\229\175\159\232\128\133\229\184\140\229\176\148\230\139\137\229\133\139",
		["Exarch Maladaar"] = "\229\164\167\228\184\187\230\149\153\231\142\155\230\139\137\232\190\190\229\176\148",
		-- Sethekk Halls
		["Talon King Ikiss"] = "\229\136\169\231\136\170\228\185\139\231\142\139\232\137\190\229\144\137\230\150\175",
		["Darkweaver Syth"] = "\233\187\145\230\154\151\231\188\150\231\187\135\232\128\133\229\161\158\230\150\175",
		-- The Mechanar
		["Gatewatcher Gyro-Kill"] = "\231\156\139\229\174\136\232\128\133\231\155\150\231\189\151\229\159\186\229\176\148",
		["Nethermancer Sepethrea"] = "\231\129\181\230\156\175\229\184\136\229\161\158\230\175\148\231\145\159\232\149\190",
		["Gatewatcher Iron-Hand"] = "\231\156\139\229\174\136\232\128\133\229\159\131\233\154\134\230\177\137",
		["Mechano-Lord Capacitus"] = "\230\156\186\230\162\176\233\162\134\228\184\187\229\141\161\229\184\149\232\165\191\229\155\190\230\150\175",
		["Pathaleon the Calculator"] = "\232\174\161\231\174\151\232\128\133\229\184\149\232\144\168\233\155\183\230\129\169\231\154\132\229\189\177\229\131\143",
		-- The Botanica
		["Commander Sarannis"] = "\230\140\135\230\140\165\229\174\152\232\144\168\230\139\137\229\166\174\228\184\157",
		["High Botanist Freywinn"] = "\233\171\152\231\186\167\230\164\141\231\137\169\229\173\166\229\174\182\229\188\151\233\155\183\230\184\169",
		["Thorngrin the Tender"] = "\231\156\139\231\174\161\232\128\133\231\180\162\230\129\169\230\160\188\230\158\151",
		["Laj"] = "\230\139\137\228\188\138",
		["Warp Splinter"] = "\232\191\129\232\183\131\230\137\173\230\156\168",
		-- The Arcatraz
		["Zereketh the Unbound"] = "\232\135\170\231\148\177\231\154\132\231\145\159\233\155\183\229\135\175\230\150\175",
		["Wrath-Scryer Soccothrates"] = "\229\164\169\230\128\146\233\162\132\232\168\128\232\128\133\232\139\143\229\133\139\230\139\137\229\186\149",
		["Dalliah the Doomsayer"] = "\230\156\171\230\151\165\233\162\132\232\168\128\232\128\133\232\190\190\229\176\148\232\142\137\229\174\137",
		["Harbinger Skyriss"] = "\233\162\132\232\168\128\232\128\133\230\150\175\229\133\139\231\145\158\230\150\175",
		["Warden Mellichar"] = "\231\155\145\230\138\164\232\128\133\230\162\133\233\135\140\229\141\161\229\176\148",
		-- The Eye
		["Kael'thas Sunstrider"] = "\229\135\175\229\176\148\232\144\168\230\150\175\194\183\233\128\144\230\151\165\232\128\133",
		["Thaladred the Darkener"] = "\228\186\181\230\184\142\232\128\133\232\144\168\230\139\137\229\190\183\233\155\183",
		["Master Engineer Telonicus"] = "\233\166\150\229\184\173\230\138\128\229\184\136\229\161\148\233\154\134\229\176\188\229\186\147\230\150\175",
		["Grand Astromancer Capernian"] = "\230\152\159\230\156\175\229\184\136\229\141\161\230\179\162\229\166\174\229\168\133",
		["Lord Sanguinar"] = "\232\144\168\229\143\164\231\186\179\229\176\148\231\148\183\231\136\181",
		["Al'ar"] = "\229\165\165",
		["High Astromancer Solarian"] = "\229\164\167\230\152\159\230\156\175\229\184\136\231\180\162\229\133\176\232\142\137\229\174\137",
		["Solarium Agent"] = "\230\151\165\230\153\183\229\175\134\230\142\162",
		["Solarium Priest"] = "\230\151\165\230\153\183\231\165\173\229\143\184",
		["Void Reaver"] = "\231\169\186\231\129\181\230\156\186\231\148\178",
		["Devastation"] = "\230\175\129\229\157\143",
		["Cosmic Infuser"] = "\229\174\135\229\174\153\231\129\140\230\179\168\232\128\133",
		["Infinity Blades"] = "\230\151\160\229\176\189\228\185\139\229\136\131",
		["Staff of Disintegration"] = "\231\147\166\232\167\163\230\179\149\230\157\150",
		["Warp Slicer"] = "\232\191\129\232\183\131\229\136\135\229\137\178\232\128\133",
		["Netherstrand Longbow"] = "\231\129\181\229\188\166\233\149\191\229\188\147",
		["Phaseshift Bulwark"] = "\231\155\184\228\189\141\229\163\129\229\158\146",

		-- Ring of Blood
		["Brokentoe"] = "\230\150\173\232\185\132",
		["Murkblood Twin"] = "\230\154\151\232\161\128\229\143\140\229\173\144",
		["Murkblood Twins"] = "\230\154\151\232\161\128\229\143\140\229\173\144",
		["The Blue Brothers"] = "The Blue Brothers",
		["Rokdar the Sundered Lord"] = "\232\163\130\231\159\179\228\185\139\231\142\139\230\180\155\229\141\161\232\190\190\229\176\148",
		["Skra'gath"] = "\231\145\159\229\133\139\230\139\137\229\138\160\230\150\175",
		["Warmaul Champion"] = "\230\136\152\230\167\140\229\139\135\229\163\171",
		["Mogor"] = "\231\169\134\230\136\136\229\176\148",

--[[    New Format Separator    ]]

--Ahn'Qiraj
		["Anubisath Defender"] = "阿努比萨斯防御者",
		["Battleguard Sartura"] = "沙尔图拉",
		["C'Thun"] = "克苏恩",
		["Emperor Vek'lor"] = "维克洛尔大帝",
		["Emperor Vek'nilash"] = "维克尼拉斯大帝",
		["Eye of C'Thun"] = "克苏恩之眼",
		["Fankriss the Unyielding"] = "顽强的范克瑞斯",
		["Lord Kri"] = "克里勋爵",
		["Ouro"] = "奥罗",
		["Princess Huhuran"] = "哈霍兰公主",
		["Princess Yauj"] = "亚尔基公主",
		["The Bug Family"] = "虫子一家",
		["The Prophet Skeram"] = "预言者斯克拉姆",
		["The Twin Emperors"] = "双子皇帝",
		["Vem"] = "维姆",
		["Viscidus"] = "维希度斯",

--Black Temple (subject to change)
		["Illidan Stormrage"] = "\228\188\138\229\136\169\228\184\185\194\183\230\128\146\233\163\142",
		["Mother Shahraz"] = "\232\142\142\232\181\171\230\139\137\228\184\157\228\184\187\230\175\141",
		["The Illidari Council"] = "\228\188\138\229\136\169\232\190\190\233\155\183\232\174\174\228\188\154",
		["Lady Malande"] = "\229\165\179\229\133\172\231\136\181\231\142\155\229\133\176\229\190\183",
		["High Warlord Naj'entus"] = "\233\171\152\233\152\182\231\157\163\229\134\155\231\186\179\229\155\160\229\155\190\230\150\175",
		["Teron Gorefiend"] = "\229\161\148\233\154\134\194\183\232\161\128\233\173\148",
		["Gathios the Shatterer"] = "\229\135\187\231\162\142\232\128\133\229\138\160\232\165\191\229\165\165\230\150\175",
		["Veras Darkshadow"] = "\232\150\135\229\176\148\232\142\177\228\184\157\194\183\230\183\177\229\189\177",
		["Gurtogg Bloodboil"] = "\229\143\164\229\176\148\229\155\190\230\160\188\194\183\232\161\128\230\178\184",
		["High Nethermancer Zerevor"] = "\233\171\152\233\152\182\231\129\181\230\156\175\229\184\136\229\161\158\229\139\146\230\178\131\229\176\148",
		["Essence of Desire"] = "\230\172\178\230\156\155\231\178\190\229\141\142",
		["Essence of Suffering"] = "\232\139\166\231\151\155\231\178\190\229\141\142",
		["Essence of Anger"] = "\230\132\164\230\128\146\231\178\190\229\141\142",
		["Reliquary of Souls"] = "\231\129\181\233\173\130\228\185\139\229\140\163",
		["Supremus"] = "\232\139\143\230\153\174\233\155\183\229\167\134\230\150\175",
		["Shade of Akama"] = "阿卡玛之影",

--Blackfathom Deeps
		["Aku'mai"] = "\233\152\191\229\186\147\233\186\166\229\176\148",
		["Baron Aquanis"] = "\233\152\191\229\165\142\229\176\188\230\150\175\231\148\183\231\136\181",
		["Gelihast"] = "\230\160\188\233\135\140\229\147\136\230\150\175\231\137\185",
		["Ghamoo-ra"] = "\229\138\160\230\145\169\230\139\137",
		["Lady Sarevess"] = "\232\144\168\229\136\169\231\187\180\228\184\157",
		["Twilight Lord Kelris"] = "\230\162\166\230\184\184\232\128\133\229\133\139\229\176\148\233\135\140\230\150\175",
		["Old Serra'kis"] = "\231\145\159\230\139\137\229\144\137\230\150\175",

--Blackrock Depths
		["Anub'shiah"] = "\233\152\191\229\138\170\229\184\140\229\176\148",
		["Gorosh the Dervish"] = "\228\191\174\232\161\140\232\128\133\233\171\152\231\189\151\228\187\128",
		["Grizzle"] = "\230\160\188\233\135\140\229\133\185\229\176\148",
		["Hedrum the Creeper"] = "\231\136\172\232\161\140\232\128\133\232\181\171\230\157\156\229\167\134",
		["High Priestess of Thaurissan"] = "\231\180\162\231\145\158\230\163\174\233\171\152\233\152\182\229\165\179\231\165\173\229\143\184",
		["Houndmaster Grebmar"] = "\233\169\175\231\138\172\232\128\133\230\160\188\233\155\183\229\184\131\231\142\155\229\176\148",
		["Lord Roccor"] = "\230\180\155\232\128\131\229\176\148",
		["Ok'thor the Breaker"] = "\231\160\180\229\157\143\232\128\133\229\165\165\231\167\145\231\180\162\229\176\148",
		["Panzor the Invincible"] = "\230\151\160\230\149\140\231\154\132\230\189\152\228\189\144\229\176\148",
		["The Seven Dwarves"] = "\228\184\131\232\180\164\231\159\174\228\186\186",
		["Verek"] = "\231\187\180\233\155\183\229\133\139",
		["Warder Stilgiss"] = "\229\133\184\231\139\177\229\174\152\230\150\175\232\191\170\229\176\148\229\159\186\230\150\175",

--Blackwing Lair
		["Broodlord Lashlayer"] = "\229\139\146\228\187\128\233\155\183\229\176\148",
		["Chromaggus"] = "\229\133\139\230\180\155\231\142\155\229\143\164\230\150\175",
		["Ebonroc"] = "\229\159\131\229\141\154\232\175\186\229\133\139",
		["Firemaw"] = "\232\180\185\229\176\148\233\187\152",
		["Flamegor"] = "\229\188\151\232\142\177\230\160\188\229\176\148",
		["Grethok the Controller"] = "\233\187\145\231\191\188\230\142\167\229\136\182\232\128\133",
		["Lord Victor Nefarius"] = "\231\187\180\229\133\139\229\164\154\194\183\229\165\136\230\179\149\233\135\140\229\165\165\230\150\175",
		["Nefarian"] = "\229\165\136\230\179\149\229\136\169\229\174\137",
		["Razorgore the Untamed"] = "\231\139\130\233\135\142\231\154\132\230\139\137\228\189\144\230\160\188\229\176\148",
		["Vaelastrasz the Corrupt"] = "\229\160\149\232\144\189\231\154\132\231\147\166\230\139\137\230\150\175\229\161\148\229\133\185",

--Gnomeregan
		["Crowd Pummeler 9-60"] = "群体打击者9-60",
		["Dark Iron Ambassador"] = "黑铁大师",
		["Electrocutioner 6000"] = "电刑器6000型",
		["Grubbis"] = "格鲁比斯",
		["Mekgineer Thermaplugg"] = "麦克尼尔·瑟玛普拉格",
		["Techbot"] = "尖端机器人",
		["Viscous Fallout"] = "粘性辐射尘",

--Gruul's Lair
		["Gruul the Dragonkiller"] = "\229\177\160\233\190\153\232\128\133\230\160\188\233\178\129\229\176\148",
		["High King Maulgar"] = "\232\142\171\229\138\160\229\176\148\229\164\167\231\142\139",
		["Kiggler the Crazed"] = "\231\150\175\231\139\130\231\154\132\229\159\186\230\136\136\229\176\148",
		["Blindeye the Seer"] = "\231\155\178\231\156\188\229\133\136\231\159\165",
		["Olm the Summoner"] = "\229\143\172\229\148\164\232\128\133\230\178\131\229\176\148\229\167\134",
		["Krosh Firehand"] = "\229\133\139\230\180\155\228\187\128\194\183\231\129\171\230\139\179",

--Hellfire Ramparts
		["Nazan"] = "\231\186\179\230\157\137",
		["Omor the Unscarred"] = "\230\151\160\231\150\164\232\128\133\229\165\165\230\145\169\229\176\148",
		["Vazruden"] = "\231\147\166\229\133\185\229\190\183",
		["Vazruden the Herald"] = "\228\188\160\228\187\164\229\174\152\231\147\166\229\133\185\229\190\183",
		["Watchkeeper Gargolmar"] = "\229\183\161\232\167\134\232\128\133\229\138\160\230\136\136\231\142\155",

--Maraudon
		["Celebras the Cursed"] = "\232\162\171\232\175\133\229\146\146\231\154\132\229\161\158\233\155\183\229\184\131\230\139\137\230\150\175",
		["Gelk"] = "\229\144\137\229\176\148\229\133\139",
		["Kolk"] = "\232\128\131\229\176\148\229\133\139",
		["Landslide"] = "\229\133\176\230\150\175\229\136\169\229\190\183",
		["Lord Vyletongue"] = "\231\187\180\229\136\169\229\161\148\230\129\169",
		["Magra"] = "\231\142\155\230\160\188\230\139\137",
		["Maraudos"] = "\231\142\155\230\139\137\229\164\154\230\150\175",
		["Meshlok the Harvester"] = "\230\148\182\229\137\178\232\128\133\233\186\166\228\187\128\230\180\155\229\133\139",
		["Noxxion"] = "\232\175\186\229\133\139\232\181\155\230\129\169",
		["Princess Theradras"] = "\231\145\159\232\142\177\229\190\183\228\184\157\229\133\172\228\184\187",
		["Razorlash"] = "\233\148\144\229\136\186\233\158\173\231\172\158\232\128\133",
		["Rotgrip"] = "\230\180\155\231\137\185\230\160\188\233\135\140\230\153\174",
		["Tinkerer Gizlock"] = "\229\183\165\229\140\160\229\144\137\229\133\185\230\180\155\229\133\139",
		["Veng"] = "\230\184\169\230\160\188",

--Molten Core
		["Baron Geddon"] = "迦顿男爵",
		["Garr"] = "加尔",
		["Gehennas"] = "基赫纳斯",
		["Golemagg the Incinerator"] = "焚化者古雷曼格",
		["Lucifron"] = "鲁西弗隆",
		["Magmadar"] = "玛格曼达",
		["Majordomo Executus"] = "管理者埃克索图斯",
		["Ragnaros"] = "拉格纳罗斯",
		["Shazzrah"] = "沙斯拉尔",
		["Sulfuron Harbinger"] = "萨弗隆先驱者",

--Naxxramas
		["Anub'Rekhan"] = "阿努布雷坎",
		["Deathknight Understudy"] = "见习死亡骑士",
		["Feugen"] = "费尔根",
		["Gluth"] = "格拉斯",
		["Gothik the Harvester"] = "收割者戈提克",
		["Grand Widow Faerlina"] = "黑女巫法琳娜",
		["Grobbulus"] = "格罗布鲁斯",
		["Heigan the Unclean"] = "肮脏的希尔盖",
		["Highlord Mograine"] = "大领主莫格莱尼",
		["Instructor Razuvious"] = "教官拉苏维奥斯",
		["Kel'Thuzad"] = "克尔苏加德",
		["Lady Blaumeux"] = "女公爵布劳缪克丝",
		["Loatheb"] = "洛欧塞布",
		["Maexxna"] = "迈克斯纳",
		["Noth the Plaguebringer"] = "瘟疫使者诺斯",
		["Patchwerk"] = "帕奇维克",
		["Sapphiron"] = "萨菲隆",
		["Sir Zeliek"] = "瑟里耶克爵士",
		["Stalagg"] = "斯塔拉格",
		["Thaddius"] = "塔迪乌斯",
		["Thane Korth'azz"] = "库尔塔兹领主",
		["The Four Horsemen"] = "四骑士",

--Ragefire Chasm
		["Bazzalan"] = "\229\183\180\230\137\142\229\133\176",
		["Jergosh the Invoker"] = "\231\165\136\230\177\130\232\128\133\232\128\182\230\136\136\228\187\128",
		["Maur Grimtotem"] = "\231\142\155\229\176\148\194\183\230\129\144\230\128\150\229\155\190\232\133\190",
		["Taragaman the Hungerer"] = "\233\165\165\233\165\191\232\128\133\229\161\148\230\139\137\229\138\160\230\155\188",

--Razorfen Downs
		["Amnennar the Coldbringer"] = "\229\175\146\229\134\176\228\185\139\231\142\139\228\186\154\233\151\168\231\186\179\229\176\148",
		["Glutton"] = "\230\154\180\233\163\159\232\128\133",
		["Mordresh Fire Eye"] = "\231\129\171\231\156\188\232\142\171\229\190\183\233\155\183\230\150\175",
		["Plaguemaw the Rotting"] = "\232\133\144\231\131\130\231\154\132\230\153\174\233\155\183\232\142\171\229\176\148",
		["Ragglesnout"] = "\230\139\137\230\136\136\230\150\175\232\175\186\231\137\185",
		["Tuten'kash"] = "\229\155\190\231\137\185\229\141\161\228\187\128",

--Razorfen Kraul
		["Agathelos the Raging"] = "\230\154\180\230\128\146\231\154\132\233\152\191\232\191\166\232\181\155\231\189\151\230\150\175",
		["Blind Hunter"] = "\231\155\178\231\156\188\231\140\142\230\137\139",
		["Charlga Razorflank"] = "\229\141\161\229\176\148\229\138\160\194\183\229\136\186\232\130\139",
		["Death Speaker Jargba"] = "\228\186\161\232\175\173\232\128\133\232\180\190\230\160\188\229\183\180",
		["Earthcaller Halmgar"] = "\229\148\164\229\156\176\232\128\133\229\147\136\231\169\134\229\138\160",
		["Overlord Ramtusk"] = "\228\184\187\229\174\176\230\139\137\229\167\134\229\161\148\230\150\175",

--Scarlet Monastery
		["Arcanist Doan"] = "\229\165\165\230\179\149\229\184\136\230\157\156\229\174\137",
		["Azshir the Sleepless"] = "\230\176\184\233\134\146\231\154\132\232\137\190\229\184\140\229\176\148",
		["Bloodmage Thalnos"] = "\232\161\128\230\179\149\229\184\136\232\144\168\229\176\148\232\175\186\230\150\175",
		["Fallen Champion"] = "\230\173\187\231\129\181\229\139\135\229\163\171",
		["Herod"] = "\232\181\171\230\180\155\229\190\183",
		["High Inquisitor Fairbanks"] = "\229\164\167\230\163\128\229\175\159\229\174\152\230\179\149\229\176\148\231\143\173\229\133\139\230\150\175",
		["High Inquisitor Whitemane"] = "\229\164\167\230\163\128\229\175\159\229\174\152\230\128\128\231\137\185\232\191\136\230\129\169",
		["Houndmaster Loksey"] = "\233\169\175\231\138\172\232\128\133\230\180\155\229\133\139\229\184\140",
		["Interrogator Vishas"] = "\229\174\161\232\174\175\229\145\152\233\159\166\230\178\153\230\150\175",
		["Ironspine"] = "\233\147\129\232\132\138\230\173\187\231\129\181",
		["Scarlet Commander Mograine"] = "\232\161\128\232\137\178\229\141\129\229\173\151\229\134\155\230\140\135\230\140\165\229\174\152\232\142\171\230\160\188\232\142\177\229\176\188",

--Serpentshrine Cavern
		["Hydross the Unstable"] = "\228\184\141\231\168\179\229\174\154\231\154\132\230\181\183\229\186\166\230\150\175",
		["Tainted Spawn of Hydross"] = "\230\177\161\230\159\147\231\154\132\230\181\183\229\186\166\230\150\175\231\136\170\231\137\153",
		["Pure Spawn of Hydross"] = "\231\186\175\229\135\128\231\154\132\230\181\183\229\186\166\230\150\175\231\136\170\231\137\153",
		["Fathom-Lord Karathress"] = "\230\183\177\230\176\180\233\162\134\228\184\187\229\141\161\230\139\137\231\145\159\233\155\183\230\150\175",
		["Morogrim Tidewalker"] = "\232\142\171\230\180\155\230\160\188\233\135\140\194\183\232\184\143\230\189\174\232\128\133",
		["Tidewalker Lurker"] = "\232\184\143\230\189\174\230\189\156\228\188\143\232\128\133",
		["Leotheras the Blind"] = "\231\155\178\231\156\188\232\128\133\232\142\177\230\172\167\231\145\159\230\139\137\230\150\175",
		["Shadow of Leotheras"] = "\232\142\177\230\172\167\231\145\159\230\139\137\230\150\175\228\185\139\229\189\177",
		["Lady Vashj"] = "\231\147\166\228\184\157\231\144\170",
		["Coilfang Elite"] = "\231\155\152\231\137\153\231\178\190\232\139\177",
		["Coilfang Strider"] = "\231\155\152\231\137\153\229\183\161\233\128\187\232\128\133",
		["The Lurker Below"] = "\233\177\188\230\150\175\230\139\137",

--Shadow Labyrinth
		["Ambassador Hellmaw"] = "赫尔默大使",
		["Blackheart the Inciter"] = "煽动者布莱卡特",
		["Grandmaster Vorpil"] = "沃匹尔大师",
		["Murmur"] = "摩摩尔",

--The Blood Furnace
		["Broggok"] = "\229\184\131\230\180\155\230\136\136\229\133\139",
		["Keli'dan the Breaker"] = "\229\135\187\231\162\142\232\128\133\229\133\139\233\135\140\228\184\185",
		["The Maker"] = "\229\136\182\233\128\160\232\128\133",

--The Deadmines
		["Brainwashed Noble"] = "\232\162\171\230\180\151\232\132\145\231\154\132\232\180\181\230\151\143",
		["Captain Greenskin"] = "\231\187\191\231\154\174\233\152\159\233\149\191",
		["Cookie"] = "\230\155\178\229\165\135",
		["Edwin VanCleef"] = "\232\137\190\229\190\183\230\184\169\194\183\232\140\131\229\133\139\233\135\140\229\164\171",
		["Gilnid"] = "\229\159\186\229\176\148\229\176\188\230\160\188",
		["Marisa du'Paige"] = "\231\142\155\233\135\140\232\142\142\194\183\230\157\156\230\180\190\230\160\188",
		["Miner Johnson"] = "\231\159\191\229\183\165\231\186\166\231\191\176\230\163\174",
		["Mr. Smite"] = "\233\135\141\230\139\179\229\133\136\231\148\159",
		["Rhahk'Zor"] = "\230\139\137\229\133\139\228\189\144",
		["Sneed"] = "\230\150\175\229\176\188\229\190\183",
		["Sneed's Shredder"] = "\230\150\175\229\176\188\229\190\183\231\154\132\228\188\144\230\156\168\230\156\186",

--The Shattered Halls
		["Grand Warlock Nethekurse"] = "\233\171\152\233\152\182\230\156\175\229\163\171\229\165\136\231\145\159\229\186\147\230\150\175",
		["Warbringer O'mrogg"] = "\230\136\152\228\186\137\228\189\191\232\128\133\230\178\131\229\167\134\231\189\151\230\160\188",
		["Warchief Kargath Bladefist"] = "\233\133\139\233\149\191\229\141\161\229\138\160\230\150\175\194\183\229\136\131\230\139\179",
		["Blood Guard Porung"] = "\232\161\128\229\141\171\229\163\171\228\188\175\233\178\129\230\129\169",

--The Slave Pens
		["Mennu the Betrayer"] = "\232\131\140\229\143\155\232\128\133\233\151\168\229\138\170",
		["Quagmirran"] = "\229\164\184\230\160\188\231\177\179\230\139\137",
		["Rokmar the Crackler"] = "\229\183\168\233\146\179\233\178\129\229\133\139\231\142\155\229\176\148",

--The Stockade
		["Bazil Thredd"] = "\229\183\180\229\159\186\229\176\148\194\183\230\150\175\231\145\158\229\190\183",
		["Bruegal Ironknuckle"] = "\229\184\131\233\178\129\233\171\152\194\183\233\147\129\230\139\179",
		["Dextren Ward"] = "\232\191\170\229\133\139\230\150\175\231\137\185\194\183\231\147\166\229\190\183",
		["Hamhock"] = "\229\147\136\229\167\134\233\156\141\229\133\139",
		["Kam Deepfury"] = "\229\141\161\229\167\134\194\183\230\183\177\230\128\146",
		["Targorr the Dread"] = "\229\143\175\230\128\149\231\154\132\229\161\148\230\160\188\229\176\148",

--The Temple of Atal'Hakkar
		["Atal'alarion"] = "\233\152\191\229\161\148\230\139\137\229\136\169\230\129\169",
		["Avatar of Hakkar"] = "\229\147\136\229\141\161\231\154\132\229\140\150\232\186\171",
		["Dreamscythe"] = "\229\190\183\229\167\134\229\161\158\229\141\161\229\176\148",
		["Hazzas"] = "\229\147\136\230\137\142\230\150\175",
		["Jammal'an the Prophet"] = "\233\162\132\232\168\128\232\128\133\232\191\166\231\142\155\229\133\176",
		["Morphaz"] = "\230\145\169\229\188\151\230\139\137\230\150\175",
		["Ogom the Wretched"] = "\229\143\175\230\130\178\231\154\132\229\165\165\230\136\136\229\167\134",
		["Shade of Eranikus"] = "\228\188\138\229\133\176\229\176\188\229\186\147\230\150\175\231\154\132\233\152\180\229\189\177",
		["Weaver"] = "\229\190\183\230\139\137\231\187\180\230\178\131\229\176\148",

--Uldaman
		["Ancient Stone Keeper"] = "\229\143\164\228\187\163\231\154\132\231\159\179\229\164\180\231\156\139\229\174\136\232\128\133",
		["Archaedas"] = "\233\152\191\230\137\142\232\190\190\230\150\175",
		["Baelog"] = "\229\183\180\229\176\148\230\180\155\230\136\136",
		["Digmaster Shovelphlange"] = "\230\140\150\230\142\152\228\184\147\229\174\182\232\136\146\229\176\148\229\188\151\230\139\137\230\160\188",
		["Galgann Firehammer"] = "\229\138\160\229\138\160\230\129\169\194\183\231\129\171\233\148\164",
		["Grimlok"] = "\230\160\188\231\145\158\229\167\134\230\180\155\229\133\139",
		["Ironaya"] = "\232\137\190\233\154\134\231\186\179\228\186\154",
		["Obsidian Sentinel"] = "\233\187\145\230\155\156\231\159\179\229\147\168\229\133\181",
		["Revelosh"] = "\233\178\129\231\187\180\231\189\151\228\187\128",

--Wailing Caverns
		["Boahn"] = "\229\141\154\232\137\190\230\129\169",
		["Deviate Faerie Dragon"] = "\229\143\152\229\188\130\231\178\190\231\129\181\233\190\153",
		["Kresh"] = "\229\133\139\233\155\183\228\187\128",
		["Lady Anacondra"] = "\229\174\137\229\168\156\231\167\145\229\190\183\230\139\137",
		["Lord Cobrahn"] = "\232\128\131\229\184\131\232\142\177\230\129\169",
		["Lord Pythas"] = "\231\154\174\232\144\168\230\150\175",
		["Lord Serpentis"] = "\231\145\159\232\138\172\232\191\170\230\150\175",
		["Mad Magglish"] = "\231\150\175\231\139\130\231\154\132\233\169\172\230\160\188\229\136\169\228\187\128",
		["Mutanus the Devourer"] = "\229\144\158\229\153\172\232\128\133\231\169\134\229\157\166\229\138\170\230\150\175",
		["Skum"] = "\230\150\175\229\141\161\229\167\134",
		["Trigore the Lasher"] = "\233\158\173\231\172\158\232\128\133\231\137\185\233\135\140\233\171\152\233\155\183",
		["Verdan the Everliving"] = "\230\176\184\231\148\159\232\128\133\230\178\131\229\176\148\228\184\185",

--World Bosses
		["Baron Kazum"] = "\229\141\161\232\139\143\229\167\134\231\148\183\231\136\181",
		["High Marshal Whirlaxis"] = "\229\164\167\229\133\131\229\184\133\231\187\180\230\139\137\229\184\140\230\150\175",
		["Lord Skwol"] = "\230\150\175\229\143\164\230\129\169\231\148\183\231\136\181",

--Zul'Aman
		["Warlord Jin'Zakk"] = "Warlord Jin'Zakk",

--Zul'Farrak
		["Antu'sul"] = "\229\174\137\229\155\190\232\139\143\229\176\148",
		["Chief Ukorz Sandscalp"] = "\228\185\140\229\133\139\229\133\185\194\183\230\178\153\233\161\182",
		["Gahz'rilla"] = "\229\138\160\229\133\185\231\145\158\230\139\137",
		["Hydromancer Velratha"] = "\230\176\180\229\141\160\229\184\136\231\187\180\232\149\190\232\144\168",
		["Nekrum Gutchewer"] = "\232\128\144\229\133\139\233\178\129\229\167\134",
		["Ruuzlu"] = "\229\141\162\229\133\185\233\178\129",
		["Sandfury Executioner"] = "\230\178\153\230\128\146\229\136\189\229\173\144\230\137\139",
		["Sergeant Bly"] = "\229\184\131\232\142\177\228\184\173\229\163\171",
		["Theka the Martyr"] = "\230\174\137\230\149\153\232\128\133\229\161\158\229\141\161",
		["Witch Doctor Zum'rah"] = "\229\183\171\229\140\187\231\165\150\231\169\134\230\139\137\230\129\169",
		["Zerillis"] = "\230\179\189\233\155\183\229\136\169\230\150\175",
		["Zul'Farrak Dead Hero"] = "\231\165\150\229\176\148\230\179\149\230\139\137\229\133\139\233\152\181\228\186\161\232\139\177\233\155\132",

--Zul'Gurub
		["Bloodlord Mandokir"] = "\232\161\128\233\162\134\228\184\187\230\155\188\229\164\154\229\159\186\229\176\148",
		["Gahz'ranka"] = "\229\138\160\229\133\185\229\133\176\229\141\161",
		["Gri'lek"] = "\230\160\188\233\135\140\233\155\183\229\133\139",
		["Hakkar"] = "\229\147\136\229\141\161",
		["Hazza'rah"] = "\229\147\136\230\137\142\230\139\137\229\176\148",
		["High Priestess Arlokk"] = "\233\171\152\233\152\182\231\165\173\229\143\184\229\168\133\229\176\148\231\189\151",
		["High Priestess Jeklik"] = "\233\171\152\233\152\182\231\165\173\229\143\184\232\128\182\229\133\139\233\135\140\229\133\139",
		["High Priestess Mar'li"] = "\233\171\152\233\152\182\231\165\173\229\143\184\231\142\155\229\176\148\233\135\140",
		["High Priest Thekal"] = "\233\171\152\233\152\182\231\165\173\229\143\184\229\161\158\229\141\161\229\176\148",
		["High Priest Venoxis"] = "\233\171\152\233\152\182\231\165\173\229\143\184\230\184\169\232\175\186\229\184\140\230\150\175",
		["Jin'do the Hexxer"] = "\229\166\150\230\156\175\229\184\136\233\135\145\229\186\166",
		["Renataki"] = "\233\155\183\231\186\179\229\161\148\229\159\186",
		["Wushoolay"] = "\228\185\140\232\139\143\233\155\183",
} end)

BabbleBoss:RegisterTranslations("zhTW", function() return {
		["Avalanchion"] = "阿瓦蘭奇奧",
		["The Windreaver"] = "烈風掠奪者",
		["Baron Charr"] = "火焰男爵查爾",
		["Princess Tempestria"] = "泰比斯蒂亞公主",
		["Onyxia"] = "奧妮克希亞",
		["Azuregos"] = "艾索雷葛斯",
		["Ysondre"] = "伊索德雷",
		["Emeriss"] = "艾莫莉絲",
		["Taerar"] = "泰拉爾",
		["Lethon"] = "雷索",
		["Ayamiss the Hunter"] = "狩獵者阿亞米斯",
		["Buru the Gorger"] = "吞咽者布魯",
		["General Rajaxx"] = "拉賈克斯將軍",
		["Lieutenant General Andorov"] = "安多洛夫中將",
		["Moam"] = "莫阿姆",
		["Anubisath Guardian"] = "阿努比薩斯守衛者",
		["Ossirian the Unscarred"] = "無疤者奧斯里安",
		["Alzzin the Wildshaper"] = "奧茲恩",
		["Ambassador Flamelash"] = "弗萊拉斯大使",
		["Anger'rel"] = "安格雷爾",
		["Archivist Galford"] = "檔案管理員加爾福特",
		["Bael'Gar"] = "貝爾加",
		["Balnazzar"] = "巴納札爾",
		["Baroness Anastari"] = "安娜絲塔麗男爵夫人",
		["Baron Rivendare"] = "瑞文戴爾男爵",
		["Cannon Master Willey"] = "炮手威利",
		["Captain Kromcrush"] = "克羅卡斯",
		["Crystal Fang"] = "水晶之牙",
		["Darkmaster Gandling"] = "黑暗院長加丁",
		["Doctor Theolen Krastinov"] = "瑟爾林·卡斯迪諾夫教授",
		["Doom'rel"] = "杜姆雷爾",
		["Dope'rel"] = "多普雷爾",
		["Emperor Dagran Thaurissan"] = "達格蘭·索瑞森大帝",
		["Fineous Darkvire"] = "弗諾斯·達克維爾",
		["Gasher"] = "加什爾",
		["General Angerforge"] = "安格弗將軍",
		["General Drakkisath"] = "達基薩斯將軍",
		["Gloom'rel"] = "格魯雷爾",
		["Golem Lord Argelmach"] = "傀儡統帥阿格曼奇",
		["Goraluk Anvilcrack"] = "古拉魯克",
		["Guard Fengus"] = "衛兵芬古斯",
		["Guard Mol'dar"] = "衛兵摩爾達",
		["Guard Slip'kik"] = "衛兵斯里基克",
		["Gyth"] = "蓋斯",
		["Halycon"] = "哈雷肯",
		["Hate'rel"] = "黑特雷爾",
		["Hearthsinger Forresten"] = "弗雷斯特恩",
		["High Interrogator Gerstahn"] = "審訊官格斯塔恩",
		["Highlord Omokk"] = "歐莫克大王",
		["Hukku"] = "胡庫",
		["Hurley Blackbreath"] = "霍爾雷·黑鬚",
		["Hydrospawn"] = "海多斯博恩",
		["Illyanna Ravenoak"] = "伊琳娜·暗木",
		["Immol'thar"] = "伊莫塔爾",
		["Instructor Malicia"] = "講師瑪麗希亞",
		["Jandice Barov"] = "詹迪斯·巴羅夫",
		["King Gordok"] = "戈多克大王",
		["Kirtonos the Herald"] = "傳令官基爾圖諾斯",
		["Lady Illucia Barov"] = "伊露希亞·巴羅夫",
		["Lethtendris"] = "蕾瑟塔蒂絲",
		["Lord Alexei Barov"] = "阿萊克斯·巴羅夫",
		["Lord Incendius"] = "伊森迪奧斯",
		["Lord Valthalak"] = "瓦薩拉克",
		["Lorekeeper Polkelt"] = "博學者普克爾特",
		["Loro"] = "洛若爾",
		["Magister Kalendris"] = "卡雷迪斯鎮長",
		["Magistrate Barthilas"] = "巴瑟拉斯鎮長",
		["Magmus"] = "瑪格姆斯",
		["Maleki the Pallid"] = "蒼白的瑪勒基",
		["Marduk Blackpool"] = "馬杜克·布萊克波爾",
		["Mijan"] = "米杉",
		["Mother Smolderweb"] = "煙網蛛后",
		["Nerub'enkan"] = "奈魯布恩坎",
		["Overlord Wyrmthalak"] = "維姆薩拉克",
		["Phalanx"] = "法拉克斯",
		["Plugger Spazzring"] = "普拉格",
		["Postmaster Malown"] = "郵差瑪羅恩",
		["Princess Moira Bronzebeard"] = "茉艾拉·銅鬚公主",
		["Prince Tortheldrin"] = "托塞德林王子",
		["Pusillin"] = "普希林",
		["Pyroguard Emberseer"] = "烈焰衛士艾博希爾",
		["Ramstein the Gorger"] = "吞嚥者拉姆斯登",
		["Ras Frostwhisper"] = "萊斯·霜語",
		["Rattlegore"] = "血骨傀儡",
		["Warchief Rend Blackhand"] = "大酋長雷德·黑手",
		["Ribbly Screwspigot"] = "雷布里·斯庫比格特",
		["Seeth'rel"] = "西斯雷爾",
		["Shadow Hunter Vosh'gajin"] = "暗影獵手沃許加斯",
		["Solakar Flamewreath"] = "索拉卡·火冠",
		["Stomper Kreeg"] = "踐踏者克雷格",
		["Tendris Warpwood"] = "特迪斯·扭木",
		["The Beast"] = "比斯巨獸",
		["The Ravenian"] = "拉文尼亞",
		["Timmy the Cruel"] = "悲慘的提米",
		["Tsu'zee"] = "蘇斯",
		["Vectus"] = "維克圖斯",
		["Vile'rel"] = "瓦勒雷爾",
		["War Master Voone"] = "指揮官沃恩",
		["Zevrim Thornhoof"] = "瑟雷姆·刺蹄",
		["Zolo"] = "祖羅",
		["Zul'Lor"] = "祖羅爾",

		-- From Mendeleev
		["Cho'Rush the Observer"] = "觀察者克魯什",
		["Lord Hel'nurath"] = "赫爾努拉斯",
		["Pimgib"] = "匹姆吉布",
		["Knot Thimblejack's Cache"] = "諾特·希姆加克的容器",
		["Archmage Arugal"] = "大法師阿魯高",
		["Arugal's Voidwalker"] = "阿魯高的虛空行者",
		["Baron Silverlaine"] = "席瓦萊恩男爵",
		["Commander Springvale"] = "指揮官斯普林瓦爾",
		["Deathsworn Captain"] = "死亡誓言者隊長",
		["Fenrus the Devourer"] = "吞噬者芬魯斯",
		["Odo the Blindwatcher"] = "盲眼守衛奧杜",
		["Razorclaw the Butcher"] = "屠夫拉佐克勞",
		["Wolf Master Nandos"] = "狼王南杜斯",
		["Kurinnaxx"] = "庫林納克斯",

		-- OUTLANDS
		-- XXX: These are subject to change and may not be correct.
		["Doom Lord Kazzak"] = "毀滅之王卡札克",
		["Doomwalker"] = "厄運行者",

		-- Karazhan
		["Prince Malchezaar"] = "莫克札王子",
		["Attumen the Huntsman"] = "獵人阿圖曼",
		["Midnight"] = "午夜",
		["Hyakiss the Lurker"] = "潛伏者亞奇斯",
		["Rokad the Ravager"] = "劫掠者·拉卡",
		["Shadikith the Glider"] = "滑翔者·薛迪依斯",
		["Moroes"] = "摩洛",
		["Maiden of Virtue"] = "貞潔聖女",
		["Dorothee"] = "桃樂絲",
		["Tito"] = "多多",
		["Tinhead"] = "機器人",
		["Strawman"] = "稻草人",
		["Roar"] = "獅子",
		["The Crone"] = "老巫婆",
		["Romulo"] = "羅慕歐",
		["Julianne"] = "茱麗葉",
		["Romulo & Julianne"] = "羅慕歐與茱麗葉",
		["The Big Bad Wolf"] = "大野狼",
		["Grandmother"] = "外婆",
		["The Curator"] = "監護者",
		["Shade of Aran"] = "埃蘭之影",
		["Terestian Illhoof"] = "泰瑞斯提安·疫蹄",
		["Kil'rek"] = "基瑞克",
		["Netherspite"] = "尼德斯",
		["Nightbane"] = "夜禍",
		["Restless Skeleton"] = "骸骨",
		["King Llane Piece"] = "萊恩王棋子",
		["Warchief Blackhand Piece"] = "黑手大酋長棋子",
		["Arcane Watchman"] = "秘法警備者",
		["Chess Event"] = "西洋棋事件",
		-- Caverns of Time
		--   Durnholde Keep
		["Lieutenant Drake"] = "中尉崔克",
		["Captain Skarloc"] = "史卡拉克上尉",
		["Epoch Hunter"] = "伊波奇獵人",
		--   The Black Morass
		["Medivh"] = "麥迪文",
		["Chrono Lord Deja"] = "克洛諾斯領主迪賈",
		["Temporus"] = "坦普拉斯",
		["Aeonus"] = "艾奧那斯",
		--   Battle of Mount Hyjal (subject to change)
		["Rage Winterchill"] = "瑞奇·寒冬",
		["Anetheron"] = "安納斯隆",
		["Kaz'rogal"] = "卡斯羅高",
		["Azgalor"] = "埃加洛爾",
		["Archimonde"] = "阿克蒙德",
		-- Magtheridon's Lair
		["Magtheridon"] = "瑪瑟里頓",
		["Hellfire Channeler"] = "地獄火導魔師",
		-- The Underbog
		["Hungarfen"] = "飢餓之牙",
		["Ghaz'an"] = "高薩安",
		["Overseer Tidewrath"] = "工頭泰洛斯",
		["Claw"] = "裂爪",
		["Swamplord Musel'ek"] = "沼澤王莫斯萊克",
		["The Black Stalker"] = "黑色捕獵者",
		-- The Steamvault
		["Hydromancer Thespia"] = "海法師希斯比亞",
		["Mekgineer Steamrigger"] = "米克吉勒·蒸氣操控者",
		["Warlord Kalithresh"] = "督軍卡利斯瑞",
		-- Mana Tombs
		["Pandemonius"] = "班提蒙尼厄斯",
		["Tavarok"] = "塔瓦洛克",
		["Nexus-Prince Shaffar"] = "奈薩斯王子薩法爾",
		-- Auchenai Crypts
		["Shirrak the Dead Watcher"] = "死亡看守者辛瑞克",
		["Exarch Maladaar"] = "主教瑪拉達爾",
		-- Sethekk Halls
		["Talon King Ikiss"] = "鷹王伊奇斯",
		["Darkweaver Syth"] = "暗法師希斯",
		-- The Mechanar
		["Gatewatcher Gyro-Kill"] = "看守者蓋洛奇歐",
		["Nethermancer Sepethrea"] = "虛空術師賽派斯瑞",
		["Gatewatcher Iron-Hand"] = "看守者鐵手",
		["Mechano-Lord Capacitus"] = "機械王卡帕希特斯",
		["Pathaleon the Calculator"] = "操縱者帕薩里歐",
		-- The Botanica
		["Commander Sarannis"] = "指揮官薩瑞尼斯",
		["High Botanist Freywinn"] = "大植物學家費瑞衛恩",
		["Thorngrin the Tender"] = "看管者索古林",
		["Laj"] = "拉杰",
		["Warp Splinter"] = "扭曲分裂者",
		-- The Arcatraz
		["Zereketh the Unbound"] = "無約束的希瑞奇斯",
		["Wrath-Scryer Soccothrates"] = "怒鐮者索寇斯瑞特",
		["Dalliah the Doomsayer"] = "末日預言者達利亞",
		["Harbinger Skyriss"] = "先驅者史蓋力司",
		["Warden Mellichar"] = "守望者米利恰爾",
		-- The Eye
		["Kael'thas Sunstrider"] = "凱爾薩斯·逐日者",
		["Thaladred the Darkener"] = "扭曲預言家薩拉瑞德",
		["Master Engineer Telonicus"] = "首席技師泰隆尼卡斯",
		["Grand Astromancer Capernian"] = "大星術師卡普尼恩",
		["Lord Sanguinar"] = "桑古納爾",
		["Al'ar"] = "歐爾",
		["High Astromancer Solarian"] = "大星術師索拉瑞恩",
		["Solarium Agent"] = "日光之室密探",
		["Solarium Priest"] = "日光之室牧師",
		["Void Reaver"] = "虛無劫掠者",
		["Devastation"] = "毀滅",
		["Cosmic Infuser"] = "宇宙灌溉者",
		["Infinity Blades"] = "無盡之刃",
		["Staff of Disintegration"] = "瓦解之杖",
		["Warp Slicer"] = "扭曲切割者",
		["Netherstrand Longbow"] = "虛空之絃長弓",
		["Phaseshift Bulwark"] = "相位堡壘",
		-- Ring of Blood
		["Brokentoe"] = "斷趾",
		["Murkblood Twin"] = "黑暗之血雙子",
		["Murkblood Twins"] = "黑暗之血雙子",
		["The Blue Brothers"] = "憂鬱兄弟黨",
		["Rokdar the Sundered Lord"] = "碎裂領主洛克達",
		["Skra'gath"] = "史卡拉克斯",
		["Warmaul Champion"] = "戰錘勇士",
		["Mogor"] = "莫古",

--[[    New Format Separator    ]]

--Ahn'Qiraj
		["Anubisath Defender"] = "阿努比薩斯防禦者",
		["Battleguard Sartura"] = "沙爾圖拉",
		["C'Thun"] = "克蘇恩",
		["Emperor Vek'lor"] = "維克洛爾大帝",
		["Emperor Vek'nilash"] = "維克尼拉斯大帝",
		["Eye of C'Thun"] = "克蘇恩之眼",
		["Fankriss the Unyielding"] = "頑強的范克里斯",
		["Lord Kri"] = "克里勳爵",
		["Ouro"] = "奧羅",
		["Princess Huhuran"] = "哈霍蘭公主",
		["Princess Yauj"] = "亞爾基公主",
		["The Bug Family"] = "蟲子家族",
		["The Prophet Skeram"] = "預言者斯克拉姆",
		["The Twin Emperors"] = "雙子皇帝",
		["Vem"] = "維姆",
		["Viscidus"] = "維希度斯",

--Black Temple (subject to change)
		["Illidan Stormrage"] = "伊利丹怒風",
		["Mother Shahraz"] = "薩拉茲女士",
		["The Illidari Council"] = "伊利達瑞議事",
		["Lady Malande"] = "瑪蘭黛女士",
		["High Warlord Naj'entus"] = "高階督軍納珍塔斯",
		["Teron Gorefiend"] = "泰朗·血魔",
		["Gathios the Shatterer"] = "粉碎者高希歐",
		["Veras Darkshadow"] = "維拉斯·深影",
		["Gurtogg Bloodboil"] = "葛塔格·血沸",
		["High Nethermancer Zerevor"] = "高等虛空術師札瑞佛",
		["Essence of Desire"] = "慾望精華",
		["Essence of Suffering"] = "受難精華",
		["Essence of Anger"] = "憤怒精華",
		["Reliquary of Souls"] = "Reliquary of Souls",
		["Supremus"] = "瑟普莫斯",
		["Shade of Akama"] = "阿卡瑪的鬼魂",

--Blackfathom Deeps
		["Aku'mai"] = "阿庫麥爾",
		["Baron Aquanis"] = "阿奎尼斯男爵",
		["Gelihast"] = "格里哈斯特",
		["Ghamoo-ra"] = "加摩拉",
		["Lady Sarevess"] = "薩利維絲",
		["Twilight Lord Kelris"] = "夢遊者克爾里斯",
		["Old Serra'kis"] = "瑟拉吉斯",

--Blackrock Depths
		["Anub'shiah"] = "阿努希爾",
		["Gorosh the Dervish"] = "修行者高羅什",
		["Grizzle"] = "格里茲爾",
		["Hedrum the Creeper"] = "爬行者赫杜姆",
		["High Priestess of Thaurissan"] = "索瑞森高階女祭司",
		["Houndmaster Grebmar"] = "馴犬者格雷布瑪爾",
		["Lord Roccor"] = "洛考爾",
		["Ok'thor the Breaker"] = "破壞者奧科索爾",
		["Panzor the Invincible"] = "無敵的潘佐爾",
		["The Seven Dwarves"] = "七矮人",
		["Verek"] = "維雷克",
		["Warder Stilgiss"] = "典獄官斯迪爾基斯",

--Blackwing Lair
		["Broodlord Lashlayer"] = "勒西雷爾",
		["Chromaggus"] = "克洛瑪古斯",
		["Ebonroc"] = "埃博諾克",
		["Firemaw"] = "費爾默",
		["Flamegor"] = "弗萊格爾",
		["Grethok the Controller"] = "黑翼控制者",
		["Lord Victor Nefarius"] = "奈法利斯",
		["Nefarian"] = "奈法利安",
		["Razorgore the Untamed"] = "狂野的拉佐格爾",
		["Vaelastrasz the Corrupt"] = "墮落的瓦拉斯塔茲",

--Gnomeregan
		["Crowd Pummeler 9-60"] = "群體打擊者9-60",
		["Dark Iron Ambassador"] = "黑鐵大師",
		["Electrocutioner 6000"] = "電刑器6000型",
		["Grubbis"] = "格魯比斯",
		["Mekgineer Thermaplugg"] = "麥克尼爾·瑟瑪普拉格",
		["Techbot"] = "尖端機器人",
		["Viscous Fallout"] = "粘性輻射塵",

--Gruul's Lair
		["Gruul the Dragonkiller"] = "弒龍者戈魯爾",
		["High King Maulgar"] = "大君王莫卡爾",
		["Kiggler the Crazed"] = "瘋癲者奇克勒",
		["Blindeye the Seer"] = "先知盲眼",
		["Olm the Summoner"] = "召喚者歐莫",
		["Krosh Firehand"] = "克羅斯·火手",

--Hellfire Ramparts
		["Nazan"] = "納桑",
		["Omor the Unscarred"] = "無疤者歐瑪爾",
		["Vazruden"] = "維斯路登",
		["Vazruden the Herald"] = "先驅者維斯路登",
		["Watchkeeper Gargolmar"] = "看護者卡爾古瑪",

--Maraudon
		["Celebras the Cursed"] = "被詛咒的塞雷布拉斯",
		["Gelk"] = "吉爾克",
		["Kolk"] = "考爾克",
		["Landslide"] = "蘭斯利德",
		["Lord Vyletongue"] = "維利塔恩",
		["Magra"] = "瑪格拉",
		["Maraudos"] = "瑪拉多斯",
		["Meshlok the Harvester"] = "收割者麥什洛克",
		["Noxxion"] = "諾克賽恩",
		["Princess Theradras"] = "瑟萊德絲公主",
		["Razorlash"] = "銳刺鞭笞者",
		["Rotgrip"] = "洛特格里普",
		["Tinkerer Gizlock"] = "工匠吉茲洛克",
		["Veng"] = "溫格",

--Molten Core
		["Baron Geddon"] = "迦頓男爵",
		["Garr"] = "加爾",
		["Gehennas"] = "基赫納斯",
		["Golemagg the Incinerator"] = "焚化者古雷曼格",
		["Lucifron"] = "魯西弗隆",
		["Magmadar"] = "瑪格曼達",
		["Majordomo Executus"] = "管理者埃克索圖斯",
		["Ragnaros"] = "拉格納羅斯",
		["Shazzrah"] = "沙斯拉爾",
		["Sulfuron Harbinger"] = "薩弗隆先驅者",

--Naxxramas
		["Anub'Rekhan"] = "阿努比瑞克漢",
		["Deathknight Understudy"] = "死亡騎士實習者",
		["Feugen"] = "伏晨",
		["Gluth"] = "古魯斯",
		["Gothik the Harvester"] = "收割者高希",
		["Grand Widow Faerlina"] = "大寡婦費琳娜",
		["Grobbulus"] = "葛羅巴斯",
		["Heigan the Unclean"] = "骯髒者海根",
		["Highlord Mograine"] = "莫格萊尼公爵",
		["Instructor Razuvious"] = "講師拉祖維斯",
		["Kel'Thuzad"] = "科爾蘇加德",
		["Lady Blaumeux"] = "女公爵布洛莫斯",
		["Loatheb"] = "憎恨者",
		["Maexxna"] = "梅克絲娜",
		["Noth the Plaguebringer"] = "瘟疫者諾斯",
		["Patchwerk"] = "縫補者",
		["Sapphiron"] = "薩菲隆",
		["Sir Zeliek"] = "札里克爵士",
		["Stalagg"] = "斯塔拉格",
		["Thaddius"] = "泰迪斯",
		["Thane Korth'azz"] = "寇斯艾茲族長",
		["The Four Horsemen"] = "四騎士",

--Ragefire Chasm
		["Bazzalan"] = "巴札蘭",
		["Jergosh the Invoker"] = "祈求者耶戈什",
		["Maur Grimtotem"] = "瑪爾·恐怖圖騰",
		["Taragaman the Hungerer"] = "饑餓者塔拉加曼",

--Razorfen Downs
		["Amnennar the Coldbringer"] = "寒冰之王亞門納爾",
		["Glutton"] = "暴食者",
		["Mordresh Fire Eye"] = "火眼莫德雷斯",
		["Plaguemaw the Rotting"] = "腐爛的普雷莫爾",
		["Ragglesnout"] = "拉戈斯諾特",
		["Tuten'kash"] = "圖特卡什",

--Razorfen Kraul
		["Agathelos the Raging"] = "暴怒的阿迦賽羅斯",
		["Blind Hunter"] = "盲眼獵手",
		["Charlga Razorflank"] = "卡爾加·刺肋",
		["Death Speaker Jargba"] = "亡語者賈格巴",
		["Earthcaller Halmgar"] = "喚地者哈穆加",
		["Overlord Ramtusk"] = "主宰拉姆塔斯",

--Scarlet Monastery
		["Arcanist Doan"] = "秘法師杜安",
		["Azshir the Sleepless"] = "永醒的艾希爾",
		["Bloodmage Thalnos"] = "血法師薩爾諾斯",
		["Fallen Champion"] = "亡靈勇士",
		["Herod"] = "赫洛德",
		["High Inquisitor Fairbanks"] = "大檢察官法爾班克斯",
		["High Inquisitor Whitemane"] = "大檢察官懷特邁恩",
		["Houndmaster Loksey"] = "馴犬者洛克希",
		["Interrogator Vishas"] = "審訊員韋沙斯",
		["Ironspine"] = "鐵脊死靈",
		["Scarlet Commander Mograine"] = "血色十字軍指揮官莫格萊尼",

--Serpentshrine Cavern
		["Hydross the Unstable"] = "不穩定者海卓司",
		["Tainted Spawn of Hydross"] = "腐化的海卓司之子",
		["Pure Spawn of Hydross"] = "純正的海卓司子嗣",
		["Fathom-Lord Karathress"] = "深淵之王卡拉薩瑞斯",
		["Morogrim Tidewalker"] = "莫洛葛利姆·潮行者",
		["Tidewalker Lurker"] = "潮行者潛伏者",
		["Leotheras the Blind"] = "盲目者李奧薩拉斯",
		["Shadow of Leotheras"] = "李奧薩拉斯的陰影",
		["Lady Vashj"] = "瓦許女士",
		["Coilfang Elite"] = "盤牙精英",
		["Coilfang Strider"] = "盤牙旅行者",
		["The Lurker Below"] = "海底潛伏者",

--Shadow Labyrinth
		["Ambassador Hellmaw"] = "海爾瑪大使",
		["Blackheart the Inciter"] = "煽動者黑心",
		["Grandmaster Vorpil"] = "領導者瓦皮歐",
		["Murmur"] = "莫爾墨",

--The Blood Furnace
		["Broggok"] = "布洛克",
		["Keli'dan the Breaker"] = "破壞者·凱利丹",
		["The Maker"] = "創造者",

--The Deadmines
		["Brainwashed Noble"] = "被洗腦的貴族",
		["Captain Greenskin"] = "綠皮隊長",
		["Cookie"] = "廚師",
		["Edwin VanCleef"] = "艾德溫·范克里夫",
		["Gilnid"] = "基爾尼格",
		["Marisa du'Paige"] = "瑪里莎·杜派格",
		["Miner Johnson"] = "礦工約翰森",
		["Mr. Smite"] = "重拳先生",
		["Rhahk'Zor"] = "拉克佐",
		["Sneed"] = "斯尼德",
		["Sneed's Shredder"] = "斯尼德的伐木機",

--The Shattered Halls
		["Grand Warlock Nethekurse"] = "大術士·奈德克斯",
		["Warbringer O'mrogg"] = "戰爭製造者·歐姆拉格",
		["Warchief Kargath Bladefist"] = "大酋長卡加斯·刃拳",
		["Blood Guard Porung"] = "血衛士波洛克",

--The Slave Pens
		["Mennu the Betrayer"] = "背叛者曼紐",
		["Quagmirran"] = "奎克米瑞",
		["Rokmar the Crackler"] = "爆破者洛克瑪",

--The Stockade
		["Bazil Thredd"] = "巴基爾·斯瑞德",
		["Bruegal Ironknuckle"] = "布魯戈·艾爾克納寇",
		["Dextren Ward"] = "迪克斯特·瓦德",
		["Hamhock"] = "哈姆霍克",
		["Kam Deepfury"] = "卡姆·深怒",
		["Targorr the Dread"] = "可怕的塔高爾",

--The Temple of Atal'Hakkar
		["Atal'alarion"] = "阿塔拉利恩",
		["Avatar of Hakkar"] = "哈卡的化身",
		["Dreamscythe"] = "德姆塞卡爾",
		["Hazzas"] = "哈札斯",
		["Jammal'an the Prophet"] = "預言者迦瑪蘭",
		["Morphaz"] = "摩弗拉斯",
		["Ogom the Wretched"] = "可悲的奧戈姆",
		["Shade of Eranikus"] = "伊蘭尼庫斯的陰影",
		["Weaver"] = "德拉維沃爾",

--Uldaman
		["Ancient Stone Keeper"] = "古代的石頭看守者",
		["Archaedas"] = "阿札達斯",
		["Baelog"] = "巴爾洛戈",
		["Digmaster Shovelphlange"] = "挖掘專家舒爾弗拉格",
		["Galgann Firehammer"] = "加加恩·火錘",
		["Grimlok"] = "格瑞姆洛克",
		["Ironaya"] = "艾隆納亞",
		["Obsidian Sentinel"] = "黑曜石哨兵",
		["Revelosh"] = "魯維羅什",

--Wailing Caverns
		["Boahn"] = "博艾恩",
		["Deviate Faerie Dragon"] = "變異精靈龍",
		["Kresh"] = "克雷什",
		["Lady Anacondra"] = "安娜科德拉",
		["Lord Cobrahn"] = "考布萊恩",
		["Lord Pythas"] = "皮薩斯",
		["Lord Serpentis"] = "瑟芬迪斯",
		["Mad Magglish"] = "瘋狂的馬格利什",
		["Mutanus the Devourer"] = "吞噬者穆坦努斯",
		["Skum"] = "斯卡姆",
		["Trigore the Lasher"] = "鞭笞者特里高雷",
		["Verdan the Everliving"] = "永生者沃爾丹",

--World Bosses
		["Baron Kazum"] = "卡蘇姆男爵",
		["High Marshal Whirlaxis"] = "大元帥維拉希斯",
		["Lord Skwol"] = "斯古恩男爵",

--Zul'Aman
		["Warlord Jin'Zakk"] = "Warlord Jin'Zakk",

--Zul'Farrak
		["Antu'sul"] = "安圖蘇爾",
		["Chief Ukorz Sandscalp"] = "烏克茲·沙頂",
		["Gahz'rilla"] = "加茲瑞拉",
		["Hydromancer Velratha"] = "水占師維蕾薩",
		["Nekrum Gutchewer"] = "耐克魯姆",
		["Ruuzlu"] = "盧茲魯",
		["Sandfury Executioner"] = "沙怒劊子手",
		["Sergeant Bly"] = "布萊中士",
		["Theka the Martyr"] = "殉教者塞卡",
		["Witch Doctor Zum'rah"] = "巫醫·祖穆拉恩",
		["Zerillis"] = "澤雷利斯",
		["Zul'Farrak Dead Hero"] = "祖爾法拉克陣亡英雄",

--Zul'Gurub
		["Bloodlord Mandokir"] = "血領主曼多基爾",
		["Gahz'ranka"] = "加茲蘭卡",
		["Gri'lek"] = "格里雷克",
		["Hakkar"] = "哈卡",
		["Hazza'rah"] = "哈札拉爾",
		["High Priestess Arlokk"] = "哈卡萊先知",
		["High Priestess Jeklik"] = "高階祭司耶克里克",
		["High Priestess Mar'li"] = "哈卡萊安魂者",
		["High Priest Thekal"] = "古拉巴什食腐者",
		["High Priest Venoxis"] = "高階祭司溫諾希斯",
		["Jin'do the Hexxer"] = "妖術師金度",
		["Renataki"] = "雷納塔基",
		["Wushoolay"] = "烏蘇雷",
} end)

BabbleBoss:RegisterTranslations("koKR", function() return {
		["Avalanchion"] = "아발란치온",
		["The Windreaver"] = "칼날바람",
		["Baron Charr"] = "남작 차르",
		["Princess Tempestria"] = "공주 템페스트리아",
		["Onyxia"] = "오닉시아",
		["Azuregos"] = "아주어고스",
		["Ysondre"] = "이손드레",
		["Emeriss"] = "에메리스",
		["Taerar"] = "타에라",
		["Lethon"] = "레손",
		["Ayamiss the Hunter"] = "사냥꾼 아야미스",
		["Buru the Gorger"] = "먹보 부루",
		["General Rajaxx"] = "장군 라작스",
		["Lieutenant General Andorov"] = "사령관 안도로브",
		["Moam"] = "모암",
		["Anubisath Guardian"] = "아누비사스 감시자",
		["Ossirian the Unscarred"] = "무적의 오시리안",
		["Alzzin the Wildshaper"] = "칼날바람 알진",
		["Ambassador Flamelash"] = "사자 화염채찍",
		["Anger'rel"] = "격노의 문지기",
		["Archivist Galford"] = "기록관 갈포드",
		["Bael'Gar"] = "벨가르",
		["Balnazzar"] = "발나자르",
		["Baroness Anastari"] = "남작부인 아나스타리",
		["Baron Rivendare"] = "남작 리븐데어",
		["Cannon Master Willey"] = "포병대장 윌리",
		["Captain Kromcrush"] = "대장 크롬크러쉬",
		["Crystal Fang"] = "수정 맹독 거미",
		["Darkmaster Gandling"] = "암흑스승 간틀링",
		["Doctor Theolen Krastinov"] = "학자 테올린 크라스티노브",
		["Doom'rel"] = "운명의 문지기",
		["Dope'rel"] = "최면의 문지기",
		["Emperor Dagran Thaurissan"] = "제왕 다그란 타우릿산",
		["Fineous Darkvire"] = "파이너스 다크바이어",
		["Gasher"] = "게이셔",
		["General Angerforge"] = "사령관 앵거포지",
		["General Drakkisath"] = "사령관 드라키사스",
		["Gloom'rel"] = "그늘의 문지기",
		["Golem Lord Argelmach"] = "골렘군주 아젤마크",
		["Goraluk Anvilcrack"] = "고랄루크 앤빌크랙",
		["Guard Fengus"] = "경비병 펜구스",
		["Guard Mol'dar"] = "경비병 몰다르",
		["Guard Slip'kik"] = "경기병 슬립킥",
		["Gyth"] = "기스",
		["Halycon"] = "할리콘",
		["Hate'rel"] = "증오의 문지기",
		["Hearthsinger Forresten"] = "하스싱어 포레스턴",
		["High Interrogator Gerstahn"] = "대심문관 게르스탄",
		["Highlord Omokk"] = "대군주 오모크",
		["Hukku"] = "후쿠",
		["Hurley Blackbreath"] = "헐레이 블랙브레스",
		["Hydrospawn"] = "히드로스폰",
		["Illyanna Ravenoak"] = "일샨나 레이븐호크",
		["Immol'thar"] = "이몰타르",
		["Instructor Malicia"] = "조교 말리시아",
		["Jandice Barov"] = "잔다이스 바로브",
		["King Gordok"] = "왕 고르독",
		["Kirtonos the Herald"] = "사자 키르토노스",
		["Lady Illucia Barov"] = "여군주 일루시아 바로브",
		["Lethtendris"] = "레스텐드리스",
		["Lord Alexei Barov"] = "군주 알렉세이 바로브",
		["Lord Incendius"] = "군주 인센디우스",
		["Lord Valthalak"] = "군주 발타라크",
		["Lorekeeper Polkelt"] = "현자 폴켈트",
		["Loro"] = "로로",
		["Magister Kalendris"] = "마법사 칼렌드리스",
		["Magistrate Barthilas"] = "집정관 바실라스",
		["Magmus"] = "마그무스",
		["Maleki the Pallid"] = "냉혈한 말레키",
		["Marduk Blackpool"] = "마르두크 블랙풀",
		["Mijan"] = "마이잔",
		["Mother Smolderweb"] = "여왕 불그물거미",
		["Nerub'enkan"] = "네룹엔칸",
		["Overlord Wyrmthalak"] = "대군주 윔타라크",
		["Phalanx"] = "팔란스",
		["Plugger Spazzring"] = "플러거스파즈링",
		["Postmaster Malown"] = "우체국장 말로운",
		["Princess Moira Bronzebeard"] = "공주 모이라 브론즈비어드",
		["Prince Tortheldrin"] = "왕자 토르텔드린",
		["Pusillin"] = "푸실린",
		["Pyroguard Emberseer"] = "불의 수호자 엠버시어",
		["Ramstein the Gorger"] = "먹보 람스타인",
		["Ras Frostwhisper"] = "라스 프로스트위스퍼",
		["Rattlegore"] = "들창어금니",
		["Warchief Rend Blackhand"] = "대족장 렌드 블랙핸드",
		["Ribbly Screwspigot"] = "리블리 스크류스피곳",
		["Seeth'rel"] = "불안의 문지기",
		["Shadow Hunter Vosh'gajin"] = "어둠사냥꾼 보쉬가진",
		["Solakar Flamewreath"] = "화염고리 솔라카르",
		["Stomper Kreeg"] = "천둥발 크리그",
		["Tendris Warpwood"] = "굽이나무 텐드리스",
		["The Beast"] = "괴수",
		["The Ravenian"] = "라베니안",
		["Timmy the Cruel"] = "잔혹한 티미",
		["Tsu'zee"] = "츄지",
		["Vectus"] = "벡투스",
		["Vile'rel"] = "타락의 문지기",
		["War Master Voone"] = "대장군 부네",
		["Zevrim Thornhoof"] = "제브림 쏜후프",
		["Zolo"] = "졸로",
		["Zul'Lor"] = "줄로",

		-- From Mendeleev
		["Cho'Rush the Observer"] = "정찰병 초루쉬",
		["Lord Hel'nurath"] = "군주 헬누라스",
		["Pimgib"] = "핌기브",
		["Knot Thimblejack's Cache"] = "노트 팀블젝의 은닉품", -- check
		["Archmage Arugal"] = "대마법사 아루갈",
		["Arugal's Voidwalker"] = "아루갈의 보이드워커",
		["Baron Silverlaine"] = "남작 실버레인",
		["Commander Springvale"] = "사령관 스프링베일",
		["Deathsworn Captain"] = "죽음의 경비대장", -- check
		["Fenrus the Devourer"] = "파멸의 펜루스",
		["Odo the Blindwatcher"] = "눈먼감시자 오도",
		["Razorclaw the Butcher"] = "도살자 칼날발톱",
		["Wolf Master Nandos"] = "늑대왕 난도스",
		["Kurinnaxx"] = "쿠린낙스",

		-- OUTLANDS
		-- XXX: These are subject to change and may not be correct.
		["Doom Lord Kazzak"] = "파멸의 군주 카자크",
		["Doomwalker"] = "파멸의 절단기",

		-- Karazhan
		["Prince Malchezaar"] = "공작 말체자르",
		["Attumen the Huntsman"] = "사냥꾼 어튜멘",
		["Midnight"] = "천둥이",
		["Hyakiss the Lurker"] = "잠복꾼 히아키스",
		["Rokad the Ravager"] = "파괴자 로카드",
		["Shadikith the Glider"] = "활강의 샤디키스",
		["Moroes"] = "모로스",
		["Maiden of Virtue"] = "고결의 여신",
		["Dorothee"] = "도로시",
		["Tito"] = "티토",
		["Tinhead"] = "양철나무꾼",
		["Strawman"] = "허수아비",
		["Roar"] = "어흥이",
		["The Crone"] = "마녀",
		["Romulo"] = "로밀로",
		["Julianne"] = "줄리엔",
		["Romulo & Julianne"] = "로밀로 & 줄리엔",
		["The Big Bad Wolf"] = "커다란 나쁜 늑대",
		["Grandmother"] = "할머니",
		["The Curator"] = "전시 관리인",
		["Shade of Aran"] = "아란의 망령",
		["Terestian Illhoof"] = "테레스티안 일후프",
		["Kil'rek"] = "킬렉",
		["Netherspite"] = "황천의 원령",
		["Nightbane"] = "파멸의 어둠",
		["Restless Skeleton"] = "잠 못 드는 해골",
		["King Llane Piece"] = "국왕 레인",
		["Warchief Blackhand Piece"] = "대족장 블랙핸드",
		["Arcane Watchman"] = "비전 보초",
		["Chess Event"] = "Chess Event",
		-- Caverns of Time
		--   Durnholde Keep
		["Lieutenant Drake"] = "부관 드레이크",
		["Captain Skarloc"] = "경비대장 스칼록",
		["Epoch Hunter"] = "시대의 사냥꾼",
		-- The Black Morass
		["Medivh"] = "메디브",
		["Chrono Lord Deja"] = "시간의 군주 데자",
		["Temporus"] = "템퍼루스",
		["Aeonus"] = "아에누스",
		--   Battle of Mount Hyjal (subject to change) -- Need fix
		["Rage Winterchill"] = "격노한 윈터칠",
		["Anetheron"] = "아네테론",
		["Kaz'rogal"] = "카즈로갈",
		["Azgalor"] = "아즈갈로",
		["Archimonde"] = "아키몬드",
		-- Magtheridon's Lair
		["Magtheridon"] = "마그테리돈",
		["Hellfire Channeler"] = "지옥불 역술사",
		-- The Underbog
		["Hungarfen"] = "헝가르펜",
		["Ghaz'an"] = "가즈안",
		["Overseer Tidewrath"] = "우두머리 성난파도",
		["Claw"] = "클로",
		["Swamplord Musel'ek"] = "늪군주 뮤즐레크",
		["The Black Stalker"] = "검은 추적자",
		-- The Steamvault
		["Hydromancer Thespia"] = "풍수사 세스피아",
		["Mekgineer Steamrigger"] = "기계공학자 스팀리거",
		["Warlord Kalithresh"] = "장군 칼리스레쉬",
		-- Mana Tombs
		["Pandemonius"] = "팬더모니우스",
		["Tavarok"] = "타바로크",
		["Nexus-Prince Shaffar"] = "연합왕자 샤파르",
		-- Auchenai Crypts
		["Shirrak the Dead Watcher"] = "죽음의 감시인 쉴라크",
		["Exarch Maladaar"] = "총독 말라다르",
		-- Sethekk Halls
		["Talon King Ikiss"] = "갈퀴대왕 이키스",
		["Darkweaver Syth"] = "흑마술사 시스",
		-- The Mechanar
		["Gatewatcher Gyro-Kill"] = "문지기 회전톱날",
		["Nethermancer Sepethrea"] = "황천술사 세페스레아",
		["Gatewatcher Iron-Hand"] = "문지기 무쇠주먹",
		["Mechano-Lord Capacitus"] = "기계군주 캐퍼시투스",
		["Pathaleon the Calculator"] = "철두철미한 파탈리온",
		-- The Botanica
		["Commander Sarannis"] = "지휘관 새래니스",
		["High Botanist Freywinn"] = "고위 식물학자 프레이윈",
		["Thorngrin the Tender"] = "감시인 쏜그린",
		["Laj"] = "라즈",
		["Warp Splinter"] = "차원의 분리자",
		-- The Arcatraz
		["Zereketh the Unbound"] = "속박이 풀린 제레케스",
		["Wrath-Scryer Soccothrates"] = "격노의 점술사 소코드라테스",
		["Dalliah the Doomsayer"] = "파멸의 예언자 달리아",
		["Harbinger Skyriss"] = "선구자 스키리스",
		["Warden Mellichar"] = "교도관 멜리챠르",
		-- The Eye
		["Kael'thas Sunstrider"] = "캘타스 선스트라이더",
		["Thaladred the Darkener"] = "암흑의 인도자 탈라드레드",
		["Master Engineer Telonicus"] = "수석기술자 텔로니쿠스",
		["Grand Astromancer Capernian"] = "대점성술사 카퍼니안",
		["Lord Sanguinar"] = "군주 생귀나르",
		["Al'ar"] = "알라르",
		["High Astromancer Solarian"] = "고위 점성술사 솔라리안",
		["Solarium Agent"] = "태양의 전당 요원",
		["Solarium Priest"] = "태양의 전당 사제",
		["Void Reaver"] = "공허의 절단기",
		["Devastation"] = "황폐의 도끼",
		["Cosmic Infuser"] = "붕괴의 지팡이",
		["Infinity Blades"] = "무한의 비수",
		["Staff of Disintegration"] = "우주 에너지 주입기",
		["Warp Slicer"] = "차원의 절단기",
		["Netherstrand Longbow"] = "황천매듭 장궁",
		["Phaseshift Bulwark"] = "위상 변화의 보루방패",
		-- Ring of Blood
		["Brokentoe"] = "망치발굽",
		["Murkblood Twin"] = "수렁피일족 쌍둥이",
		["Murkblood Twins"] = "수렁피일족 쌍둥이",
		["The Blue Brothers"] = "푸른 형제들",
		["Rokdar the Sundered Lord"] = "파괴의 군주 로크다르",
		["Skra'gath"] = "스크라가스",
		["Warmaul Champion"] = "전쟁망치일족 용사",
		["Mogor"] = "모고르",

--[[    New Format Separator    ]]

--Ahn'Qiraj
		["Anubisath Defender"] = "아누비사스 문지기",
		["Battleguard Sartura"] = "전투감시병 살투라",
		["C'Thun"] = "쑨",
		["Emperor Vek'lor"] = "제왕 베클로어",
		["Emperor Vek'nilash"] = "제왕 베크닐라쉬",
		["Eye of C'Thun"] = "쑨의 눈",
		["Fankriss the Unyielding"] = "불굴의 판크리스",
		["Lord Kri"] = "군주 크리",
		["Ouro"] = "아우로",
		["Princess Huhuran"] = "공주 후후란",
		["Princess Yauj"] = "공주 야우즈",
		["The Bug Family"] = "벌레 무리",
		["The Prophet Skeram"] = "예언자 스케람",
		["The Twin Emperors"] = "쌍둥이 제왕",
		["Vem"] = "벰",
		["Viscidus"] = "비시디우스",

--Black Temple
		["Illidan Stormrage"] = "일리단 스톰레이지",
		["Mother Shahraz"] = "대모 샤라즈",
		["The Illidari Council"] = "일리다리 의회", -- check
		["Lady Malande"] = "여군주 말란데",
		["High Warlord Naj'entus"] = "대장군 나젠투스",
		["Teron Gorefiend"] = "테론 고어핀드",
		["Gathios the Shatterer"] = "파괴자 가디오스",
		["Veras Darkshadow"] = "베라스 다크섀도",
		["Gurtogg Bloodboil"] = "구르토그 블러드보일", -- check
		["High Nethermancer Zerevor"] = "고위 황천술사 제레보르",
		["Essence of Desire"] = "욕망의 정수",
		["Essence of Suffering"] = "고뇌의 정수",
		["Essence of Anger"] = "격노의 정수",
		["Reliquary of Souls"] = "영혼의 성물함",
		["Supremus"] = "궁극의 심연",
		["Shade of Akama"] = "아카마의 망령",

--Blackfathom Deeps
		["Aku'mai"] = "아쿠마이",
		["Baron Aquanis"] = "남작 아쿠아니스",
		["Gelihast"] = "겔리하스트",
		["Ghamoo-ra"] = "가무라 ",
		["Lady Sarevess"] = "여왕 사레베스",
		["Twilight Lord Kelris"] = "황혼의 군주 켈리스",
		["Old Serra'kis"] = "늙은 세라키스",

--Blackrock Depths
		["Anub'shiah"] = "아눕쉬아",
		["Gorosh the Dervish"] = "광신자 고로쉬", --check
		["Grizzle"] = "그리즐",
		["Hedrum the Creeper"] = "왕거미 헤드룸",
		["High Priestess of Thaurissan"] = "타우릿산의 대여사제",
		["Houndmaster Grebmar"] = "사냥개조련사 그렙마르",
		["Lord Roccor"] = "불의군주 록코르",
		["Ok'thor the Breaker"] = "파괴자 오크토르",
		["Panzor the Invincible"] = "무적의 판저",
		["The Seven Dwarves"] = "The Seven Dwarves",
		["Verek"] = "베레크",
		["Warder Stilgiss"] = "문지기 스틸기스",

--Blackwing Lair
		["Broodlord Lashlayer"] = "용기대장 래쉬레이어",
		["Chromaggus"] = "크로마구스",
		["Ebonroc"] = "에본로크",
		["Firemaw"] = "화염아귀",
		["Flamegor"] = "플레임고르",
		["Grethok the Controller"] = "감시자 그레토크",
		["Lord Victor Nefarius"] = "군주 빅터 네파리우스",
		["Nefarian"] = "네파리안",
		["Razorgore the Untamed"] = "폭군 서슬송곳니",
		["Vaelastrasz the Corrupt"] = "타락한 밸라스트라즈",

--Gnomeregan
		["Crowd Pummeler 9-60"] = "고철 압축기 9-60",
		["Dark Iron Ambassador"] = "검은무쇠단 사절",
		["Electrocutioner 6000"] = "기계화 문지기 6000",
		["Grubbis"] = "그루비스 ",
		["Mekgineer Thermaplugg"] = "멕기니어 텔마플러그",
		["Techbot"] = "첨단로봇",
		["Viscous Fallout"] = "방사성 폐기물",

--Gruul's Lair
		["Gruul the Dragonkiller"] = "용 학살자 그룰",
		["High King Maulgar"] = "왕중왕 마울가르",
		["Kiggler the Crazed"] = "광기의 키글러",
		["Blindeye the Seer"] = "현자 블라인드아이",
		["Olm the Summoner"] = "소환사 올름",
		["Krosh Firehand"] = "크로쉬 파이어핸드",

--Hellfire Ramparts
		["Nazan"] = "나잔",
		["Omor the Unscarred"] = "무적의 오모르",
		["Vazruden"] = "바즈루덴",
		["Vazruden the Herald"] = "사자 바즈루덴",
		["Watchkeeper Gargolmar"] = "감시자 가르골마르",

--Maraudon
		["Celebras the Cursed"] = "저주받은 셀레브라스",
		["Gelk"] = "겔크",
		["Kolk"] = "콜크",
		["Landslide"] = "산사태",
		["Lord Vyletongue"] = "군주 바일텅",
		["Magra"] = "마그라",
		["Maraudos"] = "마라우도스",
		["Meshlok the Harvester"] = "정원사 메슬로크",
		["Noxxion"] = "녹시온",
		["Princess Theradras"] = "공주 테라드라스",
		["Razorlash"] = "칼날채찍",
		["Rotgrip"] = "썩은 아귀",
		["Tinkerer Gizlock"] = "땜장이 기즐록",
		["Veng"] = "벵",

--Molten Core
		["Baron Geddon"] = "남작 게돈",
		["Garr"] = "가르",
		["Gehennas"] = "게헨나스",
		["Golemagg the Incinerator"] = "초열의 골레마그",
		["Lucifron"] = "루시프론",
		["Magmadar"] = "마그마다르",
		["Majordomo Executus"] = "청지기 이그젝큐투스",
		["Ragnaros"] = "라그나로스",
		["Shazzrah"] = "샤즈라",
		["Sulfuron Harbinger"] = "설퍼론 사자",

--Naxxramas
		["Anub'Rekhan"] = "아눕레칸",
		["Deathknight Understudy"] = "죽음의 기사 수습생",
		["Feugen"] = "퓨진",
		["Gluth"] = "글루스",
		["Gothik the Harvester"] = "영혼의 착취자 고딕",
		["Grand Widow Faerlina"] = "귀부인 팰리나",
		["Grobbulus"] = "그라불루스",
		["Heigan the Unclean"] = "부정의 헤이건",
		["Highlord Mograine"] = "대영주 모그레인",
		["Instructor Razuvious"] = "훈련교관 라주비어스",
		["Kel'Thuzad"] = "켈투자드",
		["Lady Blaumeux"] = "여군주 블라미우스",
		["Loatheb"] = "로데브",
		["Maexxna"] = "맥스나",
		["Noth the Plaguebringer"] ="역병술사 노스",
		["Patchwerk"] = "패치워크",
		["Sapphiron"] = "사피론",
		["Sir Zeliek"] = "젤리에크 경",
		["Stalagg"] = "스탈라그",
		["Thaddius"] = "타디우스",
		["Thane Korth'azz"] = "영주 코스아즈",
		["The Four Horsemen"] = "4인의 기병대",

--Ragefire Chasm
		["Bazzalan"] = "바잘란",
		["Jergosh the Invoker"] = "기원사 제로쉬",
		["Maur Grimtotem"] = "마우르 그림토템",
		["Taragaman the Hungerer"] = "욕망의 타라가만",

--Razorfen Downs
		["Amnennar the Coldbringer"] = "혹한의 암네나르",
		["Glutton"] = "게걸먹보",
		["Mordresh Fire Eye"] = "불꽃눈 모드레쉬",
		["Plaguemaw the Rotting"] = "썩어가는 역병아귀",
		["Ragglesnout"] = "너덜주둥이",
		["Tuten'kash"] = "투텐카쉬",

--Razorfen Kraul
		["Agathelos the Raging"] = "흉포한 아가테로스",
		["Blind Hunter"] = "장님 사냥꾼",
		["Charlga Razorflank"] = "서슬깃 차를가",
		["Death Speaker Jargba"] = "죽음의 예언자 잘그바",
		["Earthcaller Halmgar"] = "대지술사 함가르",
		["Overlord Ramtusk"] = "대군주 램터스크",

--Scarlet Monastery
		["Arcanist Doan"] = "신비술사 도안",
		["Azshir the Sleepless"] = "잠들지 않는 아즈시르",
		["Bloodmage Thalnos"] = "혈법사 탈노스",
		["Fallen Champion"] = "타락한 용사",
		["Herod"] = "헤로드",
		["High Inquisitor Fairbanks"] = "종교재판관 페어뱅크스",
		["High Inquisitor Whitemane"] = "종교재판관 화이트메인",
		["Houndmaster Loksey"] = "사냥개 조련사 록시",
		["Interrogator Vishas"] = "심문관 비샤스",
		["Ironspine"] = "무쇠해골",
		["Scarlet Commander Mograine"] = "붉은십자군 사령관 모그레인",

--Serpentshrine Cavern
		["Hydross the Unstable"] = "불안정한 히드로스",
		["Tainted Spawn of Hydross"] = "오염된 히드로스의 피조물",
		["Pure Spawn of Hydross"] = "순수한 히드로스의 피조물",
		["Fathom-Lord Karathress"] = "심연의 군주 카라드레스",
		["Morogrim Tidewalker"] = "겅둥파도 모로그림",
		["Tidewalker Lurker"] = "겅둥파도 잠복꾼",
		["Leotheras the Blind"] = "눈먼 레오테라스",
		["Shadow of Leotheras"] = "레오테라스의 그림자",
		["Lady Vashj"] = "여군주 바쉬",
		["Coilfang Elite"] = "갈퀴송곳니 정예병",
		["Coilfang Strider"] = "갈퀴송곳니 포자손",
		["The Lurker Below"] = "심연의 잠복꾼",

--Shadow Labyrinth
		["Ambassador Hellmaw"] = "사자 지옥아귀",
		["Blackheart the Inciter"] = "선동자 검은심장",
		["Grandmaster Vorpil"] = "단장 보르필",
		["Murmur"] = "울림",

--The Blood Furnace
		["Broggok"] = "브로고크",
		["Keli'dan the Breaker"] = "파괴자 켈리단",
		["The Maker"] = "재앙의 창조자",

--The Deadmines
		["Brainwashed Noble"] = "세뇌당한 귀족",
		["Captain Greenskin"] = "선장 그린스킨",
		["Cookie"] = "쿠키",
		["Edwin VanCleef"] = "에드윈 밴클리프",
		["Gilnid"] = "길니드",
		["Marisa du'Paige"] = "마리사 두페이지",
		["Miner Johnson"] = "광부 존슨",
		["Mr. Smite"] = "미스터 스마이트",
		["Rhahk'Zor"] = "라크조르",
		["Sneed"] = "스니드",
		["Sneed's Shredder"] = "스니드의 벌목기",

--The Shattered Halls
		["Grand Warlock Nethekurse"] = "대흑마법사 네더쿠르스",
		["Warbringer O'mrogg"] = "돌격대장 오므로그",
		["Warchief Kargath Bladefist"] = "대족장 카르가스 블레이드피스트",
		["Blood Guard Porung"] = "혈투사 포룽",

--The Slave Pens
		["Mennu the Betrayer"] = "배반자 멘누",
		["Quagmirran"] = "쿠아그미란",
		["Rokmar the Crackler"] = "딱딱이 로크마르",

--The Stockade
		["Bazil Thredd"] = "바질 스레드",
		["Bruegal Ironknuckle"] = "무쇠주먹 브루갈",
		["Dextren Ward"] = "덱스트렌 워드",
		["Hamhock"] = "햄혹",
		["Kam Deepfury"] = "캄 딥퓨리",
		["Targorr the Dread"] = "흉악범 타고르",

--The Temple of Atal'Hakkar
		["Atal'alarion"] = "아탈알라리온",
		["Avatar of Hakkar"] = "학카르의 화신",
		["Dreamscythe"] = "드림사이드",
		["Hazzas"] = "하자스",
		["Jammal'an the Prophet"] = "예언자 잠말란",
		["Morphaz"] = "몰파즈",
		["Ogom the Wretched"] = "비운의 오그옴",
		["Shade of Eranikus"] = "에라니쿠스의 사령",
		["Weaver"] = "위버",

--Uldaman
		["Ancient Stone Keeper"] = "고대 바위 문지기",
		["Archaedas"] = "아카에다스",
		["Baelog"] = "밸로그",
		["Digmaster Shovelphlange"] = "발굴단장 쇼벨플랜지",
		["Galgann Firehammer"] = "갈간 파이어해머",
		["Grimlok"] = "그림로크",
		["Ironaya"] = "아이로나야",
		["Obsidian Sentinel"] = "흑요석 파수꾼",
		["Revelosh"] = "레벨로쉬",

--Wailing Caverns
		["Boahn"] = "보안",
		["Deviate Faerie Dragon"] = "돌연변이 요정용",
		["Kresh"] = "크레쉬",
		["Lady Anacondra"] = "여군주 아나콘드라",
		["Lord Cobrahn"] = "군주 코브란",
		["Lord Pythas"] = "군주 피타스",
		["Lord Serpentis"] = "군주 서펜디스",
		["Mad Magglish"] = "광기의 매글리시",
		["Mutanus the Devourer"] = "걸신들린 무타누스",
		["Skum"] = "스컴",
		["Trigore the Lasher"] = "채찍꼬리 트리고어",
		["Verdan the Everliving"] = "영생의 베르단",

--World Bosses
		["Baron Kazum"] = "남작 카줌",
		["High Marshal Whirlaxis"] = "대장군 휠락시스", -- check
		["Lord Skwol"] = "군주 스퀄",

--Zul'Aman
		["Warlord Jin'Zakk"] = "Warlord Jin'Zakk",

--Zul'Farrak
		["Antu'sul"] = "안투술",
		["Chief Ukorz Sandscalp"] = "족장 우코르즈 샌드스칼프",
		["Gahz'rilla"] = "가즈릴라",
		["Hydromancer Velratha"] = "유체술사 벨라타",
		["Nekrum Gutchewer"] = "네크룸 거트츄어",
		["Ruuzlu"] = "루즐루",
		["Sandfury Executioner"] = "성난모래부족 사형집행인",
		["Sergeant Bly"] = "하사관 블라이",
		["Theka the Martyr"] = "순교자 데카",
		["Witch Doctor Zum'rah"] = "의술사 줌라",
		["Zerillis"] = "제릴리스",
		["Zul'Farrak Dead Hero"] = "줄파락 죽음의 영웅",

--Zul'Gurub
		["Bloodlord Mandokir"] = "혈군주 만도키르",
		["Gahz'ranka"] = "가즈란카",
		["Gri'lek"] = "그리렉",
		["Hakkar"] = "학카르",
		["Hazza'rah"] = "하자라",
		["High Priestess Arlokk"] = "대여사제 알로크",
		["High Priestess Jeklik"] = "대여사제 제클릭",
		["High Priestess Mar'li"] = "대여사제 말리",
		["High Priest Thekal"] = "대사제 데칼",
		["High Priest Venoxis"] = "대사제 베녹시스",
		["Jin'do the Hexxer"] = "주술사 진도",
		["Renataki"] = "레나타키",
		["Wushoolay"] = "우슬레이",
	} end)

BabbleBoss:RegisterTranslations("esES", function() return {
		["Avalanchion"] = "Avalanchion",
		["The Windreaver"] = "El Atracavientos",
		["Baron Charr"] = "Bar\195\179n Charr",
		["Princess Tempestria"] = "Princesa Tempestria",
		["Onyxia"] = "Onyxia",
		["Azuregos"] = "Azuregos",
		["Ysondre"] = "Ysondre",
		["Emeriss"] = "Emeriss",
		["Taerar"] = "Taerar",
		["Lethon"] = "Lethon",
		["Ayamiss the Hunter"] = "Ayamiss el Cazador",
		["Buru the Gorger"] = "Buru el Manducador",
		["General Rajaxx"] = "General Rajaxx",
		["Lieutenant General Andorov"] = "Teniente General Andorov",
		["Moam"] = "Moam",
		["Anubisath Guardian"] = "Guardi\195\161n Anubisath",
		["Ossirian the Unscarred"] = "Osirio el Sinmarcas",
		["Alzzin the Wildshaper"] = "Alzzin el Formaferal",
		["Ambassador Flamelash"] = "Embajador Latifuego",
		["Anger'rel"] = "Anger'rel",
		["Archivist Galford"] = "Archivista Galford",
		["Bael'Gar"] = "Bael'Gar",
		["Balnazzar"] = "Balnazzar",
		["Baroness Anastari"] = "Baronesa Anastari",
		["Baron Rivendare"] = "Bar\195\179n Rivendare",
		["Cannon Master Willey"] = "Ca\195\177onero Jefe Willey",
		["Captain Kromcrush"] = "Capit\195\161n Kromcrush",
		["Crystal Fang"] = "Colmillor de cristal",
		["Darkmaster Gandling"] = "Maestro oscuro Gandling",
		["Doctor Theolen Krastinov"] = "Doctor Theolen Krastinov",
		["Doom'rel"] = "Doom'rel",
		["Dope'rel"] = "Dope'rel",
		["Emperor Dagran Thaurissan"] = "Emperador Dagran Thaurissan",
		["Fineous Darkvire"] = "Finoso Virunegro",
		["Gasher"] = "Gasher",
		["General Angerforge"] = "General Forjira",
		["General Drakkisath"] = "General Drakkisath",
		["Gloom'rel"] = "Gloom'rel",
		["Golem Lord Argelmach"] = "Se\195\177or G\195\179lem Argelmach",
		["Goraluk Anvilcrack"] = "Goraluk Yunquegrieta",
		["Guard Fengus"] = "Guardia Fengus",
		["Guard Mol'dar"] = "	Guardia Mol'dar",
		["Guard Slip'kik"] = "Guardia Slip'kik",
		["Gyth"] = "Gyth",
		["Halycon"] = "Halycon",
		["Hate'rel"] = "Odio'rel",
		["Hearthsinger Forresten"] = "Escupezones Foreste",
		["High Interrogator Gerstahn"] = "Alto Interrogador Gerstahn",
		["Highlord Omokk"] = "Alto Se\195\177or Omokk",
		["Hukku"] = "Hukku",
		["Hurley Blackbreath"] = "Hurley Negr\195\161lito",
		["Hydrospawn"] = "Hidromilecio",
		["Illyanna Ravenoak"] = "Illyanna Roblecuervo",
		["Immol'thar"] = "Immol'thar",
		["Instructor Malicia"] = "Instructor Malicia",
		["Jandice Barov"] = "Jandice Barov",
		["King Gordok"] = "Rey Gordok",
		["Kirtonos the Herald"] = "Kirtonos el Heraldo",
		["Lady Illucia Barov"] = "Lady Illucia Barov",
		["Lethtendris"] = "Lethtendris",
		["Lord Alexei Barov"] = "Lord Alexei Barov",
		["Lord Incendius"] = "Lord Incendius",
		["Lord Valthalak"] = "Lord Valthalak",
		["Lorekeeper Polkelt"] = "Tradicionalista Polkelt",
		["Loro"] = "Loro",
		["Magister Kalendris"] = "Magister Kalendris",
		["Magistrate Barthilas"] = "Magistrado Barthilas",
		["Magmus"] = "Magmus",
		["Maleki the Pallid"] = "Maleki el P\195\161lido",
		["Marduk Blackpool"] = "Marduz Pozonegro",
		["Mijan"] = "Mijar",
		["Mother Smolderweb"] = "Madre Telabrasada",
		["Nerub'enkan"] = "Nerub'enkan",
		["Overlord Wyrmthalak"] = "Se\195\177or Supremo Vermiothalak",
		["Phalanx"] = "Falange",
		["Plugger Spazzring"] = "Plugger Aropatoso",
		["Postmaster Malown"] = "Jefe de correos Malown",    -- check
		["Princess Moira Bronzebeard"] = "Princesa Moira Barbabronce",
		["Prince Tortheldrin"] = "Pr\195\173ncipe Tortheldrin",
		["Pusillin"] = "Pusill\195\173n",
		["Pyroguard Emberseer"] = "Piroguardi\195\161n Brasadivino",
		["Ramstein the Gorger"] = "Ramstein el Empachador",
		["Ras Frostwhisper"] = "Ras Levescarcha",
		["Rattlegore"] = "Traquesangre",
		["Warchief Rend Blackhand"] = "Jefe de Guerra Desgarro Pu\195\177o Negro",
		["Ribbly Screwspigot"] = "Ribbly Llavenrosca",
		["Seeth'rel"] = "Seeth'rel",
		["Shadow Hunter Vosh'gajin"] = "Cazador de las Sombras Vosh'gajin",
		["Solakar Flamewreath"] = "Solakar Corona de Fuego",
		["Stomper Kreeg"] = "Vapuleador Kreeg",
		["Tendris Warpwood"] = "Tendris Madeguerra",
		["The Beast"] = "La Bestia",
		["The Ravenian"] = "El Devorador",
		["Timmy the Cruel"] = "Timmy el Cruel",
		["Tsu'zee"] = "Tsu'zee",
		["Vectus"] = "Vectus",
		["Vile'rel"] = "Vil'rel",
		["War Master Voone"] = "Maestro de guerra Voone",
		["Zevrim Thornhoof"] = "Zevrim Pezu\195\177ahendida",
		["Zolo"] = "Zolo",
		["Zul'Lor"] = "Zul'Lor",

		-- From Mendeleev
		["Cho'Rush the Observer"] = "Cho'Rush el Observador",
		["Lord Hel'nurath"] = "Lord Hel'nurath",    -- check
		["Pimgib"] = "Pimgib",
		["Knot Thimblejack's Cache"] = "Carretilla de Knot Llavededo",
		["Archmage Arugal"] = "Archimago Arugal",
		["Arugal's Voidwalker"] = "Abisario de Arugal",  -- "Arugal's Voidwalker"
		["Baron Silverlaine"] = "Bar\195\179n Filargenta",
		["Commander Springvale"] = "Comandante Vallefont",
		["Deathsworn Captain"] = "Capit\195\161n Juramorte",
		["Fenrus the Devourer"] = "Fenrus el Devorador",
		["Odo the Blindwatcher"] = "Odo el vig\195\173a ciego",
		["Razorclaw the Butcher"] = "Zarpador el Carnicero",
		["Wolf Master Nandos"] = "Maestro de lobos Nandos",
		["Kurinnaxx"] = "Kurinnaxx",

		-- OUTLANDS
		-- XXX: These are subject to change and may not be correct.
		["Doom Lord Kazzak"] = "Señor Apocalíptico Kazzak",
		["Doomwalker"] = "Caminante del Destino",  -- check

		-- Karazhan
		["Prince Malchezaar"] = "Pr\195\173ncipe Malchezaar",
		["Attumen the Huntsman"] = "Attumen el Montero",
		["Midnight"] = "Medianoche",
		["Hyakiss the Lurker"] = "Hyakiss el Rondador",
		["Rokad the Ravager"] = "Rokad el Devastador",
		["Shadikith the Glider"] = "Shadikith the Glider",  -- fix
		["Moroes"] = "Moroes",
		["Maiden of Virtue"] = "Doncella de Virtud",
		["Dorothee"] = "Dorothea",
		["Tito"] = "Tito",
		["Tinhead"] = "Cabezalata",
		["Strawman"] = "Espantapájaros",
		["Roar"] = "Rugido",
		["The Crone"] = "La Vieja Bruja",  -- check
		["Romulo"] = "Romulo",
		["Julianne"] = "Julianne",
		["Romulo & Julianne"] = "Romulo y Julianne", -- check
		["The Big Bad Wolf"] = "El Gran Lobo Malvado",
		["Grandmother"] = "Abuela",
		["The Curator"] = "Curator",
		["Shade of Aran"] = "Sombra de Aran",
		["Terestian Illhoof"] = "Terestian Pezuña Enferma",
		["Kil'rek"] = "Kil'rek",
		["Netherspite"] = "Rencor abisal",  -- check
		["Nightbane"] = "Nocturno",  -- check
		["Restless Skeleton"] = "Esqueleto inquieto",  -- check
		["King Llane Piece"] = "Rey Llane",  -- check - Pieza de...
		["Warchief Blackhand Piece"] = "Jefe de Guerra Mano Negra",  -- check - Pieza de...
		["Arcane Watchman"] = "Vigilante Arcano",
		["Chess Event"] = "Evento de ajedrez", -- check
		-- Caverns of Time
		--   Durnholde Keep
		["Lieutenant Drake"] = "Teniente Draco",
		["Captain Skarloc"] = "Capitán Skarloc",
		["Epoch Hunter"] = "Cazador de eras",
		--   The Black Morass
		["Medivh"] = "Medivh",
		["Chrono Lord Deja"] = "Cronolord Deja",
		["Temporus"] = "Temporus",
		["Aeonus"] = "Aeonus",
		--   Battle of Mount Hyjal (subject to change)
		["Rage Winterchill"] = "Rage Winterchill",  -- fix
		["Anetheron"] = "Anetheron",
		["Kaz'rogal"] = "Kaz'rogal",
		["Azgalor"] = "Azgalor",
		["Archimonde"] = "Archimonde",  -- fix
		-- Magtheridon's Lair
		["Magtheridon"] = "Magtheridon",
		["Hellfire Channeler"] = "Canalizador Fuego Infernal",
		-- The Underbog
		["Hungarfen"] = "Panthambre",
		["Ghaz'an"] = "Ghaz'an",
		["Overseer Tidewrath"] = "Avizor Aleta de Cólera",
		["Claw"] = "Zarpa",
		["Swamplord Musel'ek"] = "Se\195\177or del pantano Musel'ek",
		["The Black Stalker"] = "La acechadora negra",
		-- The Steamvault
		["Hydromancer Thespia"] = "Hidrom\195\161ntico Thespia",
		["Mekgineer Steamrigger"] = "Mekigeniero Vaporino",
		["Warlord Kalithresh"] = "Se\195\177or de la Guerra Kalithresh",
		-- Mana Tombs
		["Pandemonius"] = "Pandemonius",
		["Tavarok"] = "Tavarok",
		["Nexus-Prince Shaffar"] = "Pr\195\173ncipe-nexo Shaffar",
		-- Auchenai Crypts
		["Shirrak the Dead Watcher"] = "Shirrak el Vig\195\173a de los Muertos",
		["Exarch Maladaar"] = "Exarca  Maladaar",
		-- Sethekk Halls
		["Talon King Ikiss"] = "Rey Garra Ikiss",
		["Darkweaver Syth"] = "Tejeoscuro Syth",
		-- The Mechanar
		["Gatewatcher Gyro-Kill"] = "Vígia de las puertas Giromata",
		["Nethermancer Sepethrea"] = "Abisálico Sepethrea",
		["Gatewatcher Iron-Hand"] = "Vigía de las puertas Manoyerro",
		["Mechano-Lord Capacitus"] = "Lord-mecano Capacitus",
		["Pathaleon the Calculator"] = "Panthaleon el Calculador",
		-- The Botanica
		["Commander Sarannis"] = "Comandante Sarannis",
		["High Botanist Freywinn"] = "Gran botánico Freywinn",
		["Thorngrin the Tender"] = "Thorngrin el Tierno",
		["Laj"] = "Laj",
		["Warp Splinter"] = "Deshecho de distorsión",  -- check
		-- The Arcatraz
		["Zereketh the Unbound"] ="Zereketh el Desatado",
		["Wrath-Scryer Soccothrates"] = "Ar\195\186spice de c\195\179lera Soccothrates",
		["Dalliah the Doomsayer"] = "Dalliah la Decidora del Destino",
		["Harbinger Skyriss"] = "Presagista Cieloriss",
		["Warden Mellichar"] = "Celador Mellichar",
		-- The Eye
		["Kael'thas Sunstrider"] = "Kael'thas Sunstrider",  -- fix
		["Thaladred the Darkener"] = "Thaladred the Darkener",  -- fix
		["Master Engineer Telonicus"] = "Master Engineer Telonicus",  -- fix
		["Grand Astromancer Capernian"] = "Grand Astromancer Capernian",  -- fix
		["Lord Sanguinar"] = "Lord Sanguinar",
		["Al'ar"] = "Al'ar",
		["High Astromancer Solarian"] = "High Astromancer Solarian",  -- fix
		["Solarium Agent"] = "Solarium Agent",  -- fix
		["Solarium Priest"] = "Solarium Priest",  -- fix
		["Void Reaver"] = "Void Reaver",  -- fix
		["Devastation"] = "Devastación",    -- check
		["Cosmic Infuser"] = "Infusor cósmico",   -- fix
		["Infinity Blades"] = "Infinity Blades",   -- fix
		["Staff of Disintegration"] = "Staff of Disintegration",  -- fix
		["Warp Slicer"] = "Warp Slicer",  -- fix
		["Netherstrand Longbow"] = "Netherstrand Longbow",  -- fix
		["Phaseshift Bulwark"] = "Phaseshift Bulwark",  -- fix
		-- Ring of Blood
		["Brokentoe"] = "Dedorroto",
		["Murkblood Twin"] = "Murkblood Twin",  -- fix
		["Murkblood Twins"] = "Murkblood Twins",  -- fix
		["The Blue Brothers"] = "Los Hermanos Azules",
		["Rokdar the Sundered Lord"] = "Rokdar el Señor Hendido",
		["Skra'gath"] = "Skra'gath",
		["Warmaul Champion"] = "Campeón Mazo de Guerra",
		["Mogor"] = "Mogor",

--[[    New Format Separator    ]]

--Ahn'Qiraj
		["Anubisath Defender"] = "Defensor Anubisath",
		["Battleguard Sartura"] = "Guardia de batalla Sartura",
		["C'Thun"] = "C'Thun",
		["Emperor Vek'lor"] = "Emperador Vek'lor",
		["Emperor Vek'nilash"] = "Emperador Vek'nilash",
		["Eye of C'Thun"] = "Ojo de C'Thun",
		["Fankriss the Unyielding"] = "Fankriss el Implacable",
		["Lord Kri"] = "Lord Kri",
		["Ouro"] = "Ouro",
		["Princess Huhuran"] = "Princesa Huhuran",
		["Princess Yauj"] = "Princesa Yauj",
		["The Bug Family"] = "La Familia Insecto",    -- check
		["The Prophet Skeram"] = "El profeta Skeram",
		["The Twin Emperors"] = "Los Emperadores Gemelos",   -- check
		["Vem"] = "Vem",
		["Viscidus"] = "Viscidus",

--Black Temple
		["Illidan Stormrage"] = "Lord Illidan Tempestira",  -- check
		["Mother Shahraz"] = "Mother Shahraz",
		["The Illidari Council"] = "The Illidari Council",
		["Lady Malande"] = "Lady Malande",
		["High Warlord Naj'entus"] = "High Warlord Naj'entus",
		["Teron Gorefiend"] = "Teron Gorefiend",
		["Gathios the Shatterer"] = "Gathios the Shatterer",
		["Veras Darkshadow"] = "Veras Darkshadow",
		["Gurtogg Bloodboil"] = "Gurtogg Bloodboil",
		["High Nethermancer Zerevor"] = "High Nethermancer Zerevor",
		["Essence of Desire"] = "Essence of Desire",
		["Essence of Suffering"] = "Essence of Suffering",
		["Essence of Anger"] = "Essence of Anger",
		["Reliquary of Souls"] = "Reliquary of Souls",
		["Supremus"] = "Supremus",
		--["Shade of Akama"] = true,

--Blackfathom Deeps
		["Aku'mai"] = "Aku'mai",
		["Baron Aquanis"] = "Bar\195\179n Aquanis",
		["Gelihast"] = "Gelihast",
		["Ghamoo-ra"] = "Ghamoo-ra",
		["Lady Sarevess"] = "Lady Sarevess",
		["Twilight Lord Kelris"] = "Se\195\177or Crepuscular Kelris",
		["Old Serra'kis"] = "Viejo Serra'kis",

--Blackrock Depths
		["Anub'shiah"] = "Anub'shiah",
		["Gorosh the Dervish"] = "Gorosh el Endemoniado",
		["Grizzle"] = "	Grisez",
		["Hedrum the Creeper"] = "Hedrum el Trepador",
		["High Priestess of Thaurissan"] = "Alta Sacerdotisa de Thaurissan", -- check
		["Houndmaster Grebmar"] = "Maestro de canes Grebmar",
		["Lord Roccor"] = "Lord Roccor",
		["Ok'thor the Breaker"] = "Ok'thor el Rompedor",
		["Panzor the Invincible"] = "Panzor el Invencible",
		["The Seven Dwarves"] = "Los Siete Enanos",  -- check
		["Verek"] = "Verek",
		["Warder Stilgiss"] = "Guarda Stilgiss",

--Blackwing Lair
		["Broodlord Lashlayer"] = "Se\195\177or de prole Capazote",
		["Chromaggus"] = "Chromaggus",
		["Ebonroc"] = "Ebonroc",
		["Firemaw"] = "Faucefogo",
		["Flamegor"] = "Flamagor",
		["Grethok the Controller"] = "Grethok el Controlador",
		["Lord Victor Nefarius"] = "Lord V\195\173ctor Nefarius",
		["Nefarian"] = "Nefarian",
		["Razorgore the Untamed"] = "Sangrevaja el Indomable",
		["Vaelastrasz the Corrupt"] = "Vaelastrasz el Corrupto",

--Gnomeregan
		["Crowd Pummeler 9-60"] = "Gopleamasa 9-60",
		["Dark Iron Ambassador"] = "Embajador Hierro Negro",
		["Electrocutioner 6000"] = "Electrocutor 6000",
		["Grubbis"] = "Grubbis",
		["Mekgineer Thermaplugg"] = "Mekigeniero Termochufe",
		["Techbot"] = "Tecnobot",
		["Viscous Fallout"] = "Radiactivo viscoso",

--Gruul's Lair
		["Gruul the Dragonkiller"] = "Gruul the Dragonkiller",
		["High King Maulgar"] = "High King Maulgar",
		["Kiggler the Crazed"] = "Kiggler the Crazed",
		["Blindeye the Seer"] = "Blindeye the Seer",
		["Olm the Summoner"] = "Olm the Summoner",
		["Krosh Firehand"] = "Krosh Firehand",

--Hellfire Ramparts
		["Nazan"] = "Nazan",
		["Omor the Unscarred"] = "Omor el Sinmarcas",
		["Vazruden"] = "Vazruden",
		["Vazruden the Herald"] = "Vazruden el Heraldo",
		["Watchkeeper Gargolmar"] = "Guardi\195\161n vig\195\173a Gargolmar",

--Maraudon
		["Celebras the Cursed"] = "Celebras el Maldito",
		["Gelk"] = "Gelk",
		["Kolk"] = "Kolk",
		["Landslide"] = "Derrumblo",
		["Lord Vyletongue"] = "Lord Lenguavil",
		["Magra"] = "Magra",
		["Maraudos"] = "Maraudos",
		["Meshlok the Harvester"] = "Meshlok el Cosechador",
		["Noxxion"] = "Noxxion",
		["Princess Theradras"] = "Princesa Theradras",
		["Razorlash"] = "Lativaja",
		["Rotgrip"] = "Escamapodrida",
		["Tinkerer Gizlock"] = "Manitas Gizlock",
		["Veng"] = "Veng",

--Molten Core
		["Baron Geddon"] = "Bar\195\179n Geddon",
		["Garr"] = "Garr",
		["Gehennas"] = "Gehennas",
		["Golemagg the Incinerator"] = "Golemagg el Incinerador",
		["Lucifron"] = "Lucifron",
		["Magmadar"] = "Magmadar",
		["Majordomo Executus"] = "Mayordomo Executus",
		["Ragnaros"] = "Ragnaros",
		["Shazzrah"] = "Shazzrah",
		["Sulfuron Harbinger"] = "Sulfuron Presagista",

--Naxxramas
		["Anub'Rekhan"] = "Anub'Rekhan",
		["Deathknight Understudy"] = "Suplente Caballero de la Muerte",
		["Feugen"] = "Feugen",
		["Gluth"] = "Gluth",
		["Gothik the Harvester"] = "Gothik el Cosechador",
		["Grand Widow Faerlina"] = "Gran Viuda Faerlina",
		["Grobbulus"] = "Grobbulus",
		["Heigan the Unclean"] = "Heigan el Impuro",
		["Highlord Mograine"] = "Alto Se\195\177or Mograine",
		["Instructor Razuvious"] = "Instructor Razuvious",
		["Kel'Thuzad"] = "Kel'Thuzad",
		["Lady Blaumeux"] = "Lady Blaumeux",
		["Loatheb"] = "Loatheb",
		["Maexxna"] = "Maexxna",
		["Noth the Plaguebringer"] = "Noth el Pesteador",
		["Patchwerk"] = "Remendejo",
		["Sapphiron"] = "Sapphiron",
		["Sir Zeliek"] = "Sir Zeliek",
		["Stalagg"] = "Stalagg",
		["Thaddius"] = "Thaddius",
		["Thane Korth'azz"] = "Thane Korth'azz",
		["The Four Horsemen"] = "Los Cuatro Jinetes",   -- check

--Ragefire Chasm
		["Bazzalan"] = "Bazzalan",
		["Jergosh the Invoker"] = "Jergosh el Convocador",
		["Maur Grimtotem"] = "Maur T\195\179tem Siniestro",
		["Taragaman the Hungerer"] = "Taragaman el Hambriento",

--Razorfen Downs
		["Amnennar the Coldbringer"] = "Amnennar el G\195\169lido",
		["Glutton"] = "Glot\195\179n",
		["Mordresh Fire Eye"] = "Mordresh Ojo de Fuego",
		["Plaguemaw the Rotting"] = "Fauzpeste el Putrefacto",
		["Ragglesnout"] = "Morrandrajos",
		["Tuten'kash"] = "Tuten'kash",

--Razorfen Kraul
		["Agathelos the Raging"] = "Agathelos el Furioso",
		["Blind Hunter"] = "Cazador ciego",
		["Charlga Razorflank"] = "Charlga Filonavaja",
		["Death Speaker Jargba"] = "M\195\169dium Jargba",
		["Earthcaller Halmgar"] = "Clamor de Tierra Halmgar",
		["Overlord Ramtusk"] = "Se\195\177or Supremo Colmicarnero",

--Scarlet Monastery
		["Arcanist Doan"] = "Arcanista Doan",
		["Azshir the Sleepless"] = "Azshir el Insomne",
		["Bloodmage Thalnos"] = "Mago sangriento Thalnos",
		["Fallen Champion"] = "Campe\195\179n ca\195\173do",
		["Herod"] = "Herod",
		["High Inquisitor Fairbanks"] = "Alto Inquisidor Ribalimpia",
		["High Inquisitor Whitemane"] = "Alta Inquisidora Melenablanca",
		["Houndmaster Loksey"] = "Maestro de canes Loksey",
		["Interrogator Vishas"] = "Interrogador Vishas",
		["Ironspine"] = "Dorsacerado",
		["Scarlet Commander Mograine"] = "Comandante Escarlata Mograine",

--Serpentshrine Cavern
		["Hydross the Unstable"] = "Hydross the Unstable",  -- fix
		["Tainted Spawn of Hydross"] = "Tainted Spawn of Hydross",  -- fix
		["Pure Spawn of Hydross"] = "Pure Spawn of Hydross",  -- fix
		["Fathom-Lord Karathress"] = "Fathom-Lord Karathress",  -- fix
		["Morogrim Tidewalker"] = "Morogrim Tidewalker",  -- fix
		["Tidewalker Lurker"] = "Tidewalker Lurker",   -- fix
		["Leotheras the Blind"] = "Leotheras the Blind",  -- fix
		["Shadow of Leotheras"] = "Shadow of Leotheras", -- Fix
		["Lady Vashj"] = "Lady Vashj",  -- fix
		["Coilfang Elite"] = "Coilfang Elite",  -- fix
		["Coilfang Strider"] = "Coilfang Strider",  -- fix
		["The Lurker Below"] = "The Lurker Below",  -- fix

--Shadow Labyrinth
		["Ambassador Hellmaw"] = "Embajador Faucinferno",
		["Blackheart the Inciter"] = "Negrozón el Incitador",
		["Grandmaster Vorpil"] = "Maestro mayor Vorpil",
		["Murmur"] = "Murmur",

--The Blood Furnace
		["Broggok"] = "Broggok",
		["Keli'dan the Breaker"] = "Keli'dan el Ultrajador",
		["The Maker"] = "El Hacedor",

--The Deadmines
		["Brainwashed Noble"] = "Noble aducido",
		["Captain Greenskin"] = "Capit\195\161n Verdepel",
		["Cookie"] = "El Chef",
		["Edwin VanCleef"] = "Edwin VanCleef",
		["Gilnid"] = "Gilnid",
		["Marisa du'Paige"] = "Marisa du'Paige",
		["Miner Johnson"] = "Minero Johnson",
		["Mr. Smite"] = "Sr. Golpin",
		["Rhahk'Zor"] = "Rhahk'Zor",
		["Sneed"] = "Sneed",
		["Sneed's Shredder"] = "Machacador de Sneed",

--The Shattered Halls
		["Grand Warlock Nethekurse"] = "Brujo supremo Malbisal",
		["Warbringer O'mrogg"] = "Belisario O'mrogg",
		["Warchief Kargath Bladefist"] = "Jefe de Guerra Garrafilada", -- check
		["Blood Guard Porung"] = "Guardia de sangre Porung", -- check

--The Slave Pens
		["Mennu the Betrayer"] = "Mennu el Traidor",
		["Quagmirran"] = "Quagmirran",
		["Rokmar the Crackler"] = "Rokmar el Crujidor",

--The Stockade
		["Bazil Thredd"] = "Bazil Thredd",
		["Bruegal Ironknuckle"] = "Bruegal Nudoferro",
		["Dextren Ward"] = "Dextren Tutor",
		["Hamhock"] = "Hamhock",
		["Kam Deepfury"] = "Kam Furiahonda",
		["Targorr the Dread"] = "Targor el Pavoroso",

--The Temple of Atal'Hakkar
		["Atal'alarion"] = "Atal'alarion",
		["Avatar of Hakkar"] = "Avatar de Hakkar",
		["Dreamscythe"] = "Guada\195\177asue\195\177os",
		["Hazzas"] = "Hazzas",
		["Jammal'an the Prophet"] = "Jammal'an el Profeta",
		["Morphaz"] = "Morphaz",
		["Ogom the Wretched"] = "Ogom el Desdichado",
		["Shade of Eranikus"] = "Sombra de Eranikus",
		["Weaver"] = "Sastr\195\179n",

--Uldaman
		["Ancient Stone Keeper"] = "Vigilante p\195\169treo anciano",
		["Archaedas"] = "Archaedas",
		["Baelog"] = "Baelog",
		["Digmaster Shovelphlange"] = "Maestro de excavación Palatiro",
		["Galgann Firehammer"] = "Galgann Flamartillo",
		["Grimlok"] = "Grimlok",
		["Ironaya"] = "Hierraya",
		["Obsidian Sentinel"] = "Centinela Obsidiano",
		["Revelosh"] = "Revelosh",

--Wailing Caverns
		["Boahn"] = "Boahn",
		["Deviate Faerie Dragon"] = "Drag\195\179n f\195\169rico descarriado",
		["Kresh"] = "Kresh",
		["Lady Anacondra"] = "Lady Anacondra",
		["Lord Cobrahn"] = "Lord Cobrahn",
		["Lord Pythas"] = "Lord Pythas",
		["Lord Serpentis"] = "Lord Serpentis",
		["Mad Magglish"] = "Magglish el Loco",
		["Mutanus the Devourer"] = "Mutanus el Devorador",
		["Skum"] = "Skum",
		["Trigore the Lasher"] = "Trigore el Azotador",
		["Verdan the Everliving"] = "Verdan el Eterno",
        
--World Bosses
        ["Baron Kazum"] = "Bar\195\179n Kazum",
        ["High Marshal Whirlaxis"] = "High Marshal Whirlaxis",
        ["Lord Skwol"] = "Lord Skwol",

--Zul'Aman
		["Warlord Jin'Zakk"] = "Warlord Jin'Zakk",

--Zul'Farrak
		["Antu'sul"] = "Antu'sul",
		["Chief Ukorz Sandscalp"] = "Jefe Ukorz Cabellarena",
		["Gahz'rilla"] = "Gahz'rilla",
		["Hydromancer Velratha"] = "Hidrom\195\161ntica Velratha",
		["Nekrum Gutchewer"] = "Nekrum Cometripas",
		["Ruuzlu"] = "Ruuzlu",
		["Sandfury Executioner"] = "Ejecutor Furiarena",
		["Sergeant Bly"] = "Sargento Bly",
		["Theka the Martyr"] = "Theka la M\195\161rtir",
		["Witch Doctor Zum'rah"] = "M\195\169dico brujo Zum'rah",
		["Zerillis"] = "Zerillis",
		["Zul'Farrak Dead Hero"] = "H\195\169roe muerto Zul'Farrak",

--Zul'Gurub
		["Bloodlord Mandokir"] = "Se\195\177or sangriento Mandokir",
		["Gahz'ranka"] = "Gahz'ranka",
		["Gri'lek"] = "Gri'lek",
		["Hakkar"] = "Hakkar",
		["Hazza'rah"] = "Hazza'rah",
		["High Priestess Arlokk"] = "Suma Sacerdotisa Arlokk",
		["High Priestess Jeklik"] = "Suma Sacerdotisa Jeklik",
		["High Priestess Mar'li"] = "Suma Sacerdotisa Mar'li",
		["High Priest Thekal"] = "Sumo Sacerdote Thekal",
		["High Priest Venoxis"] = "Sumo Sacerdote Venoxis",
		["Jin'do the Hexxer"] = "Jin'do el Aojador",
		["Renataki"] = "Renataki",
		["Wushoolay"] = "Wushoolay",
	} end)

BabbleBoss:Debug()
BabbleBoss:SetStrictness(true)

AceLibrary:Register(BabbleBoss, MAJOR_VERSION, MINOR_VERSION)
BabbleBoss = nil